/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.backend.impl.lucene.works.AddWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.ByTermDeleteWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.ByTermUpdateWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteExtWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.FlushWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.OptimizeWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.PurgeAllWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.UpdateExtWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkDelegate;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneWorkVisitor
implements WorkVisitor<LuceneWorkDelegate> {
    private static final Log log = LoggerFactory.make();
    private final AddWorkDelegate addDelegate;
    private final DeleteWorkDelegate deleteDelegate;
    private final UpdateWorkDelegate updateDelegate;
    private final OptimizeWorkDelegate optimizeDelegate;
    private final PurgeAllWorkDelegate purgeAllDelegate;
    private final FlushWorkDelegate flushDelegate;

    public LuceneWorkVisitor(Workspace workspace) {
        this.addDelegate = new AddWorkDelegate(workspace);
        if (workspace.areSingleTermDeletesSafe()) {
            this.deleteDelegate = new DeleteExtWorkDelegate(workspace);
            this.updateDelegate = new UpdateExtWorkDelegate(workspace, this.addDelegate);
        } else if (workspace.isDeleteByTermEnforced()) {
            this.deleteDelegate = new ByTermDeleteWorkDelegate(workspace);
            this.updateDelegate = new ByTermUpdateWorkDelegate(workspace, this.addDelegate);
        } else {
            this.deleteDelegate = new DeleteWorkDelegate(workspace);
            this.updateDelegate = new UpdateWorkDelegate(this.deleteDelegate, this.addDelegate);
            log.singleTermDeleteDisabled(workspace.getIndexName());
        }
        this.purgeAllDelegate = new PurgeAllWorkDelegate(workspace);
        this.optimizeDelegate = new OptimizeWorkDelegate(workspace);
        this.flushDelegate = new FlushWorkDelegate(workspace);
    }

    @Override
    public LuceneWorkDelegate getDelegate(AddLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return this.deleteDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return this.optimizeDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return this.purgeAllDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(UpdateLuceneWork updateLuceneWork) {
        return this.updateDelegate;
    }

    @Override
    public LuceneWorkDelegate getDelegate(FlushLuceneWork flushLuceneWork) {
        return this.flushDelegate;
    }
}

