/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.query.fieldcache.impl.FieldCacheLoadingType;

public enum NumericFieldBridge implements FieldBridge,
TwoWayFieldBridge
{
    BYTE_FIELD_BRIDGE{

        @Override
        public FieldCacheLoadingType getFieldCacheLoadingType() {
            return FieldCacheLoadingType.BYTE_AS_SHORT;
        }

        @Override
        public Object get(String name, Document document) {
            IndexableField field = document.getField(name);
            return field != null ? Byte.valueOf(field.numericValue().byteValue()) : null;
        }

        @Override
        protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
            super.applyToLuceneOptions(luceneOptions, name, value.intValue(), document);
        }
    }
    ,
    SHORT_FIELD_BRIDGE{

        @Override
        public FieldCacheLoadingType getFieldCacheLoadingType() {
            return FieldCacheLoadingType.INT_AS_SHORT;
        }

        @Override
        public Object get(String name, Document document) {
            IndexableField field = document.getField(name);
            return field != null ? Short.valueOf(field.numericValue().shortValue()) : null;
        }

        @Override
        protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
            super.applyToLuceneOptions(luceneOptions, name, value.intValue(), document);
        }
    }
    ,
    INT_FIELD_BRIDGE{

        @Override
        public FieldCacheLoadingType getFieldCacheLoadingType() {
            return FieldCacheLoadingType.INT;
        }
    }
    ,
    FLOAT_FIELD_BRIDGE{

        @Override
        public FieldCacheLoadingType getFieldCacheLoadingType() {
            return FieldCacheLoadingType.FLOAT;
        }
    }
    ,
    DOUBLE_FIELD_BRIDGE{

        @Override
        public FieldCacheLoadingType getFieldCacheLoadingType() {
            return FieldCacheLoadingType.DOUBLE;
        }
    }
    ,
    LONG_FIELD_BRIDGE{

        @Override
        public FieldCacheLoadingType getFieldCacheLoadingType() {
            return FieldCacheLoadingType.LONG;
        }
    };


    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            if (luceneOptions.indexNullAs() != null) {
                luceneOptions.addFieldToDocument(name, luceneOptions.indexNullAs(), document);
            }
        } else {
            this.applyToLuceneOptions(luceneOptions, name, (Number)value, document);
        }
    }

    @Override
    public final String objectToString(Object object) {
        return object == null ? null : object.toString();
    }

    @Override
    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        if (field != null) {
            return field.numericValue();
        }
        return null;
    }

    protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
        luceneOptions.addNumericFieldToDocument(name, value, document);
    }

    public abstract FieldCacheLoadingType getFieldCacheLoadingType();
}

