/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.Set;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.EntryRetrievalCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.Transport;

public class PartitionHandlingInterceptor
extends CommandInterceptor {
    PartitionHandlingManager partitionHandlingManager;
    private Transport transport;
    private DistributionManager distributionManager;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager, Transport transport, DistributionManager distributionManager) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.transport = transport;
        this.distributionManager = distributionManager;
    }

    private boolean performPartitionCheck(InvocationContext ctx, LocalFlagAffectedCommand command) {
        if (!ctx.isOriginLocal()) {
            return true;
        }
        Set<Flag> flags = command.getFlags();
        return flags == null || !flags.contains((Object)Flag.CACHE_MODE_LOCAL);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected Object handleSingleWrite(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitEntryRetrievalCommand(InvocationContext ctx, EntryRetrievalCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object result;
        Object key = command.getKey();
        try {
            result = super.visitGetKeyValueCommand(ctx, command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw this.getLog().degradedModeKeyUnavailable(key);
            }
            throw e;
        }
        this.postOperationPartitionCheck(ctx, command, key, result);
        return result;
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        Object result;
        Object key = command.getKey();
        try {
            result = super.visitGetCacheEntryCommand(ctx, command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw this.getLog().degradedModeKeyUnavailable(key);
            }
            throw e;
        }
        this.postOperationPartitionCheck(ctx, command, key, result);
        return result;
    }

    private Object postOperationPartitionCheck(InvocationContext ctx, AbstractDataCommand command, Object key, Object result) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkRead(key);
            if (result == null && !InfinispanCollections.containsAny(this.transport.getMembers(), this.distributionManager.locate(key))) {
                throw this.getLog().degradedModeKeyUnavailable(key);
            }
        }
        return result;
    }
}

