/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class AsyncStoreConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<Long> FLUSH_LOCK_TIMEOUT = AttributeDefinition.builder((String)"flushLockTimeout", (Object)1L).build();
    public static final AttributeDefinition<Integer> MODIFICATION_QUEUE_SIZE = AttributeDefinition.builder((String)"modificationQueueSize", (Object)1024).immutable().build();
    public static final AttributeDefinition<Long> SHUTDOWN_TIMEOUT = AttributeDefinition.builder((String)"shutdownTimeout", (Object)TimeUnit.SECONDS.toMillis(25L)).build();
    public static final AttributeDefinition<Integer> THREAD_POOL_SIZE = AttributeDefinition.builder((String)"threadPoolSize", (Object)1).immutable().build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Long> flushLockTimeout;
    private final Attribute<Integer> modificationQueueSize;
    private final Attribute<Long> shutdownTimeout;
    private final Attribute<Integer> threadPoolSize;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AsyncStoreConfiguration.class, new AttributeDefinition[]{ENABLED, FLUSH_LOCK_TIMEOUT, MODIFICATION_QUEUE_SIZE, SHUTDOWN_TIMEOUT, THREAD_POOL_SIZE});
    }

    AsyncStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.flushLockTimeout = attributes.attribute(FLUSH_LOCK_TIMEOUT);
        this.modificationQueueSize = attributes.attribute(MODIFICATION_QUEUE_SIZE);
        this.shutdownTimeout = attributes.attribute(SHUTDOWN_TIMEOUT);
        this.threadPoolSize = attributes.attribute(THREAD_POOL_SIZE);
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public long flushLockTimeout() {
        return (Long)this.flushLockTimeout.get();
    }

    public AsyncStoreConfiguration flushLockTimeout(long l) {
        this.flushLockTimeout.set((Object)l);
        return this;
    }

    public int modificationQueueSize() {
        return (Integer)this.modificationQueueSize.get();
    }

    public long shutdownTimeout() {
        return (Long)this.shutdownTimeout.get();
    }

    public AsyncStoreConfiguration shutdownTimeout(long l) {
        this.shutdownTimeout.set((Object)l);
        return this;
    }

    public int threadPoolSize() {
        return (Integer)this.threadPoolSize.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AsyncStoreConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncStoreConfiguration other = (AsyncStoreConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

