/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.List;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.impl.BaseQuery;

final class EmbeddedLuceneQuery
extends BaseQuery
implements LuceneQuery {
    private final SearchManager sm;
    private final LuceneQueryParsingResult parsingResult;
    private final long startOffset;
    private final int maxResults;
    private CacheQuery cacheQuery = null;

    public EmbeddedLuceneQuery(QueryFactory queryFactory, String jpaQuery, SearchManager sm, LuceneQueryParsingResult parsingResult, long startOffset, int maxResults) {
        super(queryFactory, jpaQuery);
        this.sm = sm;
        this.parsingResult = parsingResult;
        this.startOffset = startOffset;
        this.maxResults = maxResults;
    }

    private CacheQuery getCacheQuery() {
        if (this.cacheQuery == null) {
            this.cacheQuery = this.sm.getQuery(this.parsingResult.getQuery(), this.parsingResult.getTargetEntity());
            if (this.parsingResult.getSort() != null) {
                this.cacheQuery = this.cacheQuery.sort(this.parsingResult.getSort());
            }
            if (this.parsingResult.getProjections() != null && !this.parsingResult.getProjections().isEmpty()) {
                this.cacheQuery = this.cacheQuery.projection(this.parsingResult.getProjections().toArray(new String[this.parsingResult.getProjections().size()]));
            }
            if (this.startOffset >= 0L) {
                this.cacheQuery = this.cacheQuery.firstResult((int)this.startOffset);
            }
            if (this.maxResults >= 0) {
                this.cacheQuery = this.cacheQuery.maxResults(this.maxResults);
            }
        }
        return this.cacheQuery;
    }

    @Override
    public <T> List<T> list() {
        return this.getCacheQuery().list();
    }

    @Override
    public ResultIterator iterator(FetchOptions fetchOptions) {
        return this.getCacheQuery().iterator(fetchOptions);
    }

    @Override
    public ResultIterator iterator() {
        return this.getCacheQuery().iterator();
    }

    @Override
    public int getResultSize() {
        return this.getCacheQuery().getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{parsingResult=" + this.parsingResult + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

