/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi.predicate;

import org.hibernate.hql.ast.spi.predicate.AbstractPredicate;
import org.hibernate.hql.ast.spi.predicate.Predicate;

public abstract class ComparisonPredicate<Q>
extends AbstractPredicate<Q> {
    protected final String propertyName;
    protected final Type type;
    protected final Object value;

    public ComparisonPredicate(String propertyName, Type type, Object value) {
        super(Predicate.Type.COMPARISON);
        this.propertyName = propertyName;
        this.type = type;
        this.value = value;
    }

    @Override
    public Q getQuery() {
        switch (this.type) {
            case LESS: {
                return this.getStrictlyLessQuery();
            }
            case LESS_OR_EQUAL: {
                return this.getLessOrEqualsQuery();
            }
            case EQUALS: {
                return this.getEqualsQuery();
            }
            case GREATER_OR_EQUAL: {
                return this.getGreaterOrEqualsQuery();
            }
            case GREATER: {
                return this.getStrictlyGreaterQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported comparison type: " + (Object)((Object)this.type));
    }

    protected abstract Q getStrictlyLessQuery();

    protected abstract Q getLessOrEqualsQuery();

    protected abstract Q getEqualsQuery();

    protected abstract Q getGreaterOrEqualsQuery();

    protected abstract Q getStrictlyGreaterQuery();

    public String toString() {
        return "( " + (Object)((Object)this.type) + " " + this.propertyName + " " + this.value + " )";
    }

    public static enum Type {
        LESS,
        LESS_OR_EQUAL,
        EQUALS,
        GREATER_OR_EQUAL,
        GREATER;

    }
}

