/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;

public final class FilterParsingResult<TypeMetadata> {
    private final BooleanExpr whereFilter;
    private final BooleanExpr havingFilter;
    private final String targetEntityName;
    private final TypeMetadata targetEntityMetadata;
    private final List<PropertyPath> projectedPaths;
    private final List<PropertyPath> groupBy;
    private final List<SortField> sortFields;

    FilterParsingResult(BooleanExpr whereFilter, BooleanExpr havingFilter, String targetEntityName, TypeMetadata targetEntityMetadata, List<PropertyPath> projectedPaths, List<PropertyPath> groupBy, List<SortField> sortFields) {
        this.whereFilter = whereFilter;
        this.havingFilter = havingFilter;
        this.targetEntityName = targetEntityName;
        this.targetEntityMetadata = targetEntityMetadata;
        this.projectedPaths = projectedPaths != null ? projectedPaths : Collections.emptyList();
        this.groupBy = groupBy != null ? groupBy : Collections.emptyList();
        this.sortFields = sortFields != null ? sortFields : Collections.emptyList();
    }

    public BooleanExpr getWhereClause() {
        return this.whereFilter;
    }

    public BooleanExpr getHavingClause() {
        return this.havingFilter;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public TypeMetadata getTargetEntityMetadata() {
        return this.targetEntityMetadata;
    }

    public List<String> getProjections() {
        ArrayList<String> projections = new ArrayList<String>(this.projectedPaths.size());
        for (PropertyPath p : this.projectedPaths) {
            projections.add(p.asStringPath());
        }
        return projections;
    }

    public List<PropertyPath> getProjectedPaths() {
        return this.projectedPaths;
    }

    public boolean hasGroupingOrAggregations() {
        if (this.havingFilter != null || !this.groupBy.isEmpty()) {
            return true;
        }
        for (PropertyPath p : this.projectedPaths) {
            if (p.getAggregationType() == null) continue;
            return true;
        }
        for (SortField s : this.sortFields) {
            if (s.getPath().getAggregationType() == null) continue;
            return true;
        }
        return false;
    }

    public List<PropertyPath> getGroupBy() {
        return this.groupBy;
    }

    public List<SortField> getSortFields() {
        return this.sortFields;
    }

    public String toString() {
        return "FilterParsingResult [filter=" + this.whereFilter + ", havingFilter=" + this.havingFilter + ", targetEntityName=" + this.targetEntityName + ", projectedPaths=" + this.projectedPaths + ", sortFields=" + this.sortFields + "]";
    }

    public static final class SortFieldImpl
    implements SortField {
        public final PropertyPath path;
        public final boolean isAscending;

        public SortFieldImpl(PropertyPath path, boolean isAscending) {
            this.path = path;
            this.isAscending = isAscending;
        }

        @Override
        public PropertyPath getPath() {
            return this.path;
        }

        @Override
        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            return "SortField(" + this.path + ", " + (this.isAscending ? "ASC" : "DESC") + ')';
        }
    }
}

