/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import org.hibernate.hql.ast.spi.EntityNamesResolver;

public final class ReflectionEntityNamesResolver
implements EntityNamesResolver {
    private final ClassLoader[] classLoaders;

    public ReflectionEntityNamesResolver(ClassLoader userClassLoader) {
        this.classLoaders = new ClassLoader[]{userClassLoader, ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
    }

    public Class<?> getClassFromName(String entityName) {
        for (ClassLoader cl : this.classLoaders) {
            try {
                if (cl != null) {
                    return Class.forName(entityName, true, cl);
                }
                return Class.forName(entityName);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return null;
    }
}

