/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;

public final class RowPropertyHelper
extends ObjectPropertyHelper<RowMetadata> {
    private static final Set<Class<?>> primitives = new HashSet();
    private final RowMetadata rowMetadata;

    public RowPropertyHelper(RowMetadata rowMetadata) {
        super(null);
        this.rowMetadata = rowMetadata;
    }

    @Override
    public RowMetadata getEntityMetadata(String targetTypeName) {
        return this.rowMetadata;
    }

    @Override
    public Class<?> getPrimitivePropertyType(String entityType, List<String> propertyPath) {
        Class<?> propType = this.getColumnAccessor(propertyPath).getPropertyType();
        if (propType.isEnum() || primitives.contains(propType)) {
            return propType;
        }
        return null;
    }

    private ColumnMetadata getColumnAccessor(List<String> propertyPath) {
        if (propertyPath.size() > 1) {
            throw new IllegalStateException("Nested attributes are not supported");
        }
        String columnName = propertyPath.get(0);
        for (ColumnMetadata c : this.rowMetadata.getColumns()) {
            if (!c.getColumnName().equals(columnName)) continue;
            return c;
        }
        throw new IllegalArgumentException("Column not found : " + columnName);
    }

    @Override
    public boolean hasProperty(String entityType, List<String> propertyPath) {
        if (propertyPath.size() > 1) {
            throw new IllegalStateException("Nested attributes are not supported");
        }
        String columnName = propertyPath.get(0);
        for (ColumnMetadata c : this.rowMetadata.getColumns()) {
            if (!c.getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEmbeddedProperty(String entityType, List<String> propertyPath) {
        return false;
    }

    @Override
    public boolean isRepeatedProperty(String entityType, List<String> propertyPath) {
        return false;
    }

    static {
        primitives.add(Date.class);
        primitives.add(String.class);
        primitives.add(Character.class);
        primitives.add(Character.TYPE);
        primitives.add(Double.class);
        primitives.add(Double.TYPE);
        primitives.add(Float.class);
        primitives.add(Float.TYPE);
        primitives.add(Long.class);
        primitives.add(Long.TYPE);
        primitives.add(Integer.class);
        primitives.add(Integer.TYPE);
        primitives.add(Short.class);
        primitives.add(Short.TYPE);
        primitives.add(Byte.class);
        primitives.add(Byte.TYPE);
        primitives.add(Boolean.class);
        primitives.add(Boolean.TYPE);
    }

    public static final class ColumnMetadata {
        private final int columnIndex;
        private final String columnName;
        private final Class<?> type;

        public ColumnMetadata(int columnIndex, String columnName, Class<?> type) {
            this.columnIndex = columnIndex;
            this.columnName = columnName;
            this.type = type;
        }

        public Object getValue(Object instance) {
            return ((Object[])instance)[this.columnIndex];
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public String toString() {
            return "ColumnMetadata{columnIndex=" + this.columnIndex + ", columnName='" + this.columnName + '\'' + ", type=" + this.type + '}';
        }
    }

    public static final class RowMetadata {
        private final ColumnMetadata[] columns;

        public RowMetadata(ColumnMetadata[] columns) {
            this.columns = columns;
        }

        public ColumnMetadata[] getColumns() {
            return this.columns;
        }
    }
}

