/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.regex.Pattern;
import org.infinispan.objectfilter.impl.predicateindex.Condition;

public final class RegexCondition
extends Condition<String> {
    private final Type type;
    private final String jpaPattern;
    private final Pattern regexPattern;
    private final String value;
    private int length;

    public RegexCondition(String jpaPattern) {
        this.jpaPattern = jpaPattern;
        if (jpaPattern.indexOf(37) == -1 && jpaPattern.indexOf(95) == -1) {
            this.type = Type.Equals;
            this.value = jpaPattern;
            this.regexPattern = null;
            this.length = -1;
        } else {
            String s;
            if (jpaPattern.charAt(0) == '%') {
                String s2 = jpaPattern.substring(1);
                if (s2.indexOf(37) == -1 && s2.indexOf(95) == -1) {
                    this.type = Type.EndsWith;
                    this.value = s2;
                    this.length = -1;
                    this.regexPattern = null;
                    return;
                }
                if (s2.indexOf(37) == s2.length() - 1 && s2.indexOf(95) == -1) {
                    this.type = Type.Contains;
                    this.value = s2.substring(0, s2.length() - 1);
                    this.length = -1;
                    this.regexPattern = null;
                    return;
                }
            } else if (jpaPattern.charAt(0) == '_') {
                String s3 = jpaPattern.substring(1);
                if (s3.indexOf(37) == -1 && s3.indexOf(95) == -1) {
                    this.type = Type.EndsWith;
                    this.value = s3;
                    this.length = jpaPattern.length();
                    this.regexPattern = null;
                    return;
                }
            } else if (jpaPattern.charAt(jpaPattern.length() - 1) == '%') {
                String s4 = jpaPattern.substring(0, jpaPattern.length() - 1);
                if (s4.indexOf(37) == -1 && s4.indexOf(95) == -1) {
                    this.type = Type.StartsWith;
                    this.value = s4;
                    this.length = -1;
                    this.regexPattern = null;
                    return;
                }
            } else if (jpaPattern.charAt(jpaPattern.length() - 1) == '_' && (s = jpaPattern.substring(0, jpaPattern.length() - 1)).indexOf(37) == -1 && s.indexOf(95) == -1) {
                this.type = Type.StartsWith;
                this.value = s;
                this.length = jpaPattern.length();
                this.regexPattern = null;
                return;
            }
            this.type = Type.Regexp;
            this.regexPattern = Pattern.compile(this.jpaWildcardToRegex(jpaPattern));
            this.value = null;
            this.length = -1;
        }
    }

    private String jpaWildcardToRegex(String jpaPattern) {
        StringBuilder sb = new StringBuilder(jpaPattern.length());
        sb.append('^');
        block5: for (int i = 0; i < jpaPattern.length(); ++i) {
            char c = jpaPattern.charAt(i);
            switch (c) {
                case '%': {
                    sb.append(".*");
                    continue block5;
                }
                case '_': {
                    sb.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }

    @Override
    public boolean match(String attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        switch (this.type) {
            case Equals: {
                return attributeValue.equals(this.value);
            }
            case StartsWith: {
                return (this.length == -1 || this.length == attributeValue.length()) && attributeValue.startsWith(this.value);
            }
            case EndsWith: {
                return (this.length == -1 || this.length == attributeValue.length()) && attributeValue.endsWith(this.value);
            }
            case Contains: {
                return attributeValue.contains(this.value);
            }
            case Regexp: {
                return this.regexPattern.matcher(attributeValue).matches();
            }
        }
        throw new IllegalStateException("Unexpected type " + (Object)((Object)this.type));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegexCondition other = (RegexCondition)obj;
        return this.jpaPattern.equals(other.jpaPattern);
    }

    public int hashCode() {
        return this.jpaPattern.hashCode();
    }

    public String toString() {
        return "RegexCondition(" + this.jpaPattern + ')';
    }

    private static enum Type {
        Regexp,
        Contains,
        StartsWith,
        EndsWith,
        Equals;

    }
}

