/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.util.concurrent.locks.RefCountingLock;
import org.infinispan.util.concurrent.locks.containers.AbstractLockContainer;
import org.infinispan.util.logging.Log;

public abstract class AbstractPerEntryLockContainer<L extends RefCountingLock>
extends AbstractLockContainer<L> {
    protected final EquivalentConcurrentHashMapV8<Object, L> locks;

    protected AbstractPerEntryLockContainer(int concurrencyLevel, Equivalence<Object> keyEquivalence) {
        this.locks = new EquivalentConcurrentHashMapV8(16, (float)concurrencyLevel, keyEquivalence, (Equivalence)AnyEquivalence.getInstance());
    }

    protected abstract L newLock();

    @Override
    public final L getLock(Object key) {
        return (L)((RefCountingLock)this.locks.get(key));
    }

    @Override
    public int getNumLocksHeld() {
        return this.locks.size();
    }

    @Override
    public int size() {
        return this.locks.size();
    }

    @Override
    public L acquireLock(Object lockOwner, Object key, long timeout, TimeUnit unit) throws InterruptedException {
        ByRef lockAcquired = ByRef.create((Object)Boolean.FALSE);
        RefCountingLock lock = (RefCountingLock)this.locks.compute(key, (k, l) -> {
            if (l == null) {
                Log log = this.getLog();
                if (log.isTraceEnabled()) {
                    log.tracef("Creating and acquiring new lock instance for key %s", Util.toStr((Object)k));
                }
                l = this.newLock();
                this.lock(l, lockOwner);
                lockAcquired.set((Object)Boolean.TRUE);
                return l;
            }
            int refCount = l.getReferenceCounter().incrementAndGet();
            if (refCount <= 1) {
                throw new IllegalStateException("Lock " + k + " acquired although it should have been removed: " + l);
            }
            return l;
        });
        if (!((Boolean)lockAcquired.get()).booleanValue()) {
            lockAcquired.set((Object)this.tryLock(lock, timeout, unit, lockOwner));
        }
        if (((Boolean)lockAcquired.get()).booleanValue()) {
            return (L)lock;
        }
        this.getLog().tracef("Timed out attempting to acquire lock for key %s after %s", key, Util.prettyPrintTime((long)timeout, (TimeUnit)unit));
        this.locks.computeIfPresent(key, (k, l) -> {
            boolean remove = l.getReferenceCounter().decrementAndGet() == 0;
            return remove ? null : l;
        });
        return null;
    }

    @Override
    public void releaseLock(Object lockOwner, Object key) {
        this.locks.computeIfPresent(key, (k, lock) -> {
            boolean remove;
            Log log = this.getLog();
            if (log.isTraceEnabled()) {
                log.tracef("Unlocking lock instance for key %s", Util.toStr((Object)k));
            }
            this.unlock(lock, lockOwner);
            int refCount = lock.getReferenceCounter().decrementAndGet();
            boolean bl = remove = refCount == 0;
            if (refCount < 0) {
                throw new IllegalStateException("Negative reference count for lock " + k + ": " + lock);
            }
            return remove ? null : lock;
        });
    }

    @Override
    public int getLockId(Object key) {
        Lock lock = this.getLock(key);
        return lock == null ? -1 : System.identityHashCode(lock);
    }

    public String toString() {
        return "AbstractPerEntryLockContainer{locks=" + this.locks + '}';
    }
}

