/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

public final class Grouper {
    private final int[] groupFieldPositions;
    private final FieldAccumulator[] accumulators;
    private final int rowLength;
    private final LinkedHashMap<GroupRowKey, Object[]> groups = new LinkedHashMap();

    public Grouper(int[] groupFieldPositions, FieldAccumulator[] accumulators) {
        this.rowLength = (groupFieldPositions != null ? groupFieldPositions.length : 0) + (accumulators != null ? accumulators.length : 0);
        if (this.rowLength == 0) {
            throw new IllegalArgumentException("Must have at least one grouping or aggregated column");
        }
        this.groupFieldPositions = groupFieldPositions;
        this.accumulators = accumulators;
    }

    public void addRow(Object[] row) {
        if (row.length != this.rowLength) {
            throw new IllegalArgumentException("Row length mismatch");
        }
        GroupRowKey groupRowKey = new GroupRowKey(row);
        Object[] existingGroup = this.groups.get(groupRowKey);
        if (existingGroup == null) {
            if (this.accumulators != null && this.accumulators.length != 0) {
                for (FieldAccumulator acc : this.accumulators) {
                    acc.init(row);
                }
            }
            this.groups.put(groupRowKey, row);
        } else if (this.accumulators != null && this.accumulators.length != 0) {
            for (FieldAccumulator acc : this.accumulators) {
                acc.update(row, existingGroup);
            }
        }
    }

    public Iterator<Object[]> getGroupIterator() {
        return new Iterator<Object[]>(){
            private final Iterator<Object[]> iterator;
            {
                this.iterator = Grouper.this.groups.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object[] next() {
                Object[] row = this.iterator.next();
                if (Grouper.this.accumulators != null && Grouper.this.accumulators.length != 0) {
                    for (FieldAccumulator acc : Grouper.this.accumulators) {
                        acc.finish(row);
                    }
                }
                return row;
            }
        };
    }

    public String toString() {
        return "Grouper{groupFieldPositions=" + Arrays.toString(this.groupFieldPositions) + ", accumulators=" + Arrays.toString(this.accumulators) + ", number of groups=" + this.groups.size() + '}';
    }

    private final class GroupRowKey {
        private final Object[] row;

        GroupRowKey(Object[] row) {
            this.row = row;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupRowKey other = (GroupRowKey)o;
            if (Grouper.this.groupFieldPositions != null && Grouper.this.groupFieldPositions.length != 0) {
                for (int pos : Grouper.this.groupFieldPositions) {
                    Object o1 = this.row[pos];
                    Object o2 = other.row[pos];
                    if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            if (Grouper.this.groupFieldPositions != null && Grouper.this.groupFieldPositions.length != 0) {
                for (int pos : Grouper.this.groupFieldPositions) {
                    Object e = this.row[pos];
                    result = 31 * result + (e == null ? 0 : e.hashCode());
                }
            }
            return result;
        }
    }
}

