/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;

public class LuceneQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<Query, LuceneQueryParsingResult> {
    private static final Log log = LoggerFactory.make();
    private final LucenePropertyHelper propertyHelper;
    private List<SortField> sortFields;

    public LuceneQueryRendererDelegate(EntityNamesResolver entityNames, SingleEntityQueryBuilder<Query> builder, Map<String, Object> namedParameters, LucenePropertyHelper propertyHelper) {
        super((PropertyHelper)propertyHelper, entityNames, builder, namedParameters);
        this.propertyHelper = propertyHelper;
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        SortField.Type sortType = SortField.Type.STRING;
        FieldBridge fieldBridge = this.propertyHelper.getFieldBridge(this.targetTypeName, propertyPath.getNodeNamesWithoutAlias());
        if (fieldBridge instanceof NumericFieldBridge) {
            NumericFieldBridge numericBridge = (NumericFieldBridge)fieldBridge;
            switch (numericBridge) {
                case INT_FIELD_BRIDGE: {
                    sortType = SortField.Type.INT;
                    break;
                }
                case LONG_FIELD_BRIDGE: {
                    sortType = SortField.Type.LONG;
                    break;
                }
                case FLOAT_FIELD_BRIDGE: {
                    sortType = SortField.Type.FLOAT;
                    break;
                }
                case DOUBLE_FIELD_BRIDGE: {
                    sortType = SortField.Type.DOUBLE;
                }
            }
        }
        this.sortFields.add(new SortField(propertyPath.asStringPathWithoutAlias(), sortType, !isAscending));
    }

    public LuceneQueryParsingResult getResult() {
        Sort sort = null;
        if (this.sortFields != null) {
            sort = new Sort(this.sortFields.toArray(new SortField[this.sortFields.size()]));
        }
        return new LuceneQueryParsingResult((Query)this.builder.build(), this.targetTypeName, this.targetType, this.projections, sort);
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            if (propertyPath.getNodes().size() == 1 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) {
                this.projections.add("__HSearch_This");
            } else {
                List names = this.resolveAlias(propertyPath);
                this.projections.add(this.join(names));
            }
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private String join(List<String> names) {
        StringBuilder projection = new StringBuilder();
        for (String name : names) {
            projection.append('.');
            projection.append(name);
        }
        return projection.substring(1);
    }
}

