/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.functional;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;

public interface Traversable<T>
extends AutoCloseable {
    public CloseableIterator<T> iterator();

    public CloseableSpliterator<T> spliterator();

    public Traversable<T> filter(Predicate<? super T> var1);

    public <R> Traversable<R> map(Function<? super T, ? extends R> var1);

    public <R> Traversable<R> flatMap(Function<? super T, ? extends Traversable<? extends R>> var1);

    public void forEach(Consumer<? super T> var1);

    public T reduce(T var1, BinaryOperator<T> var2);

    public Optional<T> reduce(BinaryOperator<T> var1);

    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    default public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.minBy(comparator));
    }

    default public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.maxBy(comparator));
    }

    public long count();

    public boolean anyMatch(Predicate<? super T> var1);

    public boolean allMatch(Predicate<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public Optional<T> findAny();

    @Override
    public void close();
}

