/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.IOException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.infinispan.commons.CacheException;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.query.indexmanager.IndexLockController;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class IndexManagerBasedLockController
implements IndexLockController {
    private static final Log log = (Log)LogFactory.getLog(IndexManagerBasedLockController.class, Log.class);
    private final DirectoryBasedIndexManager indexManager;
    private final TransactionManager tm;

    public IndexManagerBasedLockController(DirectoryBasedIndexManager indexManager, TransactionManager tm) {
        this.indexManager = indexManager;
        this.tm = tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForAvailability() {
        Transaction tx = this.suspendTxIfExists();
        try {
            boolean waitForAvailabilityInternal = this.waitForAvailabilityInternal();
            log.waitingForLockAcquired(waitForAvailabilityInternal);
            boolean bl = waitForAvailabilityInternal;
            return bl;
        }
        finally {
            this.resumeTx(tx);
        }
    }

    private boolean waitForAvailabilityInternal() {
        Directory directory = this.indexManager.getDirectoryProvider().getDirectory();
        Lock lock = directory.makeLock("write.lock");
        try {
            if (!lock.isLocked()) {
                return true;
            }
            try {
                boolean obtained = lock.obtain(10000L);
                if (obtained) {
                    lock.close();
                    return true;
                }
            }
            catch (LockObtainFailedException lofe) {
                return false;
            }
        }
        catch (IOException e) {
            log.error(e);
            return false;
        }
        return false;
    }

    private void resumeTx(Transaction tx) {
        if (tx != null) {
            try {
                this.tm.resume(tx);
            }
            catch (Exception e) {
                throw new CacheException("Unable to resume suspended transaction " + tx, (Throwable)e);
            }
        }
    }

    private Transaction suspendTxIfExists() {
        if (this.tm == null) {
            return null;
        }
        try {
            Transaction tx = null;
            tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
            }
            return tx;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void forceLockClear() {
        Transaction tx = this.suspendTxIfExists();
        try {
            this.forceLockClearInternal();
        }
        finally {
            this.resumeTx(tx);
        }
    }

    private void forceLockClearInternal() {
        Directory directory = this.indexManager.getDirectoryProvider().getDirectory();
        log.warn("Forcing clear of index lock");
        ((DirectoryExtensions)directory).forceUnlock("write.lock");
    }
}

