/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;

public final class ReadWriteManyCommand<K, V, R>
implements WriteCommand {
    public static final byte COMMAND_ID = 52;
    private Set<? extends K> keys;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;
    private int topologyId = -1;
    boolean isForwarded = false;
    private List<R> remoteReturns = new ArrayList<R>();
    private FunctionalNotifier<K, V> notifier;

    public ReadWriteManyCommand(Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        this.keys = keys;
        this.f = f;
    }

    public ReadWriteManyCommand(ReadWriteManyCommand command) {
        this.keys = command.keys;
        this.f = command.f;
    }

    public ReadWriteManyCommand() {
    }

    public void init(FunctionalNotifier<K, V> notifier) {
        this.notifier = notifier;
    }

    public Set<? extends K> getKeys() {
        return this.keys;
    }

    public void setKeys(Set<? extends K> keys) {
        this.keys = keys;
    }

    @Override
    public byte getCommandId() {
        return 52;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.keys = (Set)parameters[0];
        this.f = (Function)parameters[1];
        this.isForwarded = (Boolean)parameters[2];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.f, this.isForwarded};
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public void addAllRemoteReturns(List<R> returns) {
        this.remoteReturns.addAll(returns);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList<R> returns = new ArrayList<R>(this.remoteReturns);
        this.keys.forEach(k -> {
            CacheEntry entry = ctx.lookupEntry(k);
            if (entry != null) {
                R r = this.f.apply(EntryViews.readWrite(entry, this.notifier));
                returns.add(r);
            }
        });
        return returns;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public Set<Flag> getFlags() {
        return null;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
    }

    @Override
    public void setFlags(Flag ... flags) {
    }

    @Override
    public boolean hasFlag(Flag flag) {
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(Metadata metadata) {
    }
}

