/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.api.functional.Traversable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.functional.impl.Iterators;
import org.infinispan.stream.CacheCollectors;

public final class Traversables {
    public static <T> Traversable<T> of(Stream<T> stream) {
        return new StreamTraversable(stream);
    }

    public static <T> Traversable<T> eager(Stream<T> stream) {
        List list = (List)stream.collect(CacheCollectors.serializableCollector(() -> Collectors.toList()));
        return new StreamTraversable(list.stream());
    }

    private Traversables() {
    }

    private static final class StreamTraversable<T>
    implements Traversable<T> {
        volatile boolean isClosed = false;
        final Stream<T> stream;

        private StreamTraversable(Stream<T> stream) {
            this.stream = stream;
        }

        public Traversable<T> filter(Predicate<? super T> p) {
            return new StreamTraversable<T>(this.stream.filter(p));
        }

        public <R> Traversable<R> map(Function<? super T, ? extends R> f) {
            return new StreamTraversable<R>(this.stream.map(f));
        }

        public <R> Traversable<R> flatMap(final Function<? super T, ? extends Traversable<? extends R>> f) {
            Function mapper = new Function<T, Stream<? extends R>>(){

                @Override
                public Stream<? extends R> apply(T t) {
                    StreamTraversable applied = (StreamTraversable)f.apply(t);
                    return applied.stream;
                }
            };
            return new StreamTraversable(this.stream.flatMap(mapper));
        }

        public void forEach(Consumer<? super T> c) {
            this.stream.forEach(c);
        }

        public T reduce(T z, BinaryOperator<T> folder) {
            return this.stream.reduce(z, folder);
        }

        public Optional<T> reduce(BinaryOperator<T> folder) {
            return this.stream.reduce(folder);
        }

        public <U> U reduce(U z, BiFunction<U, ? super T, U> mapper, BinaryOperator<U> folder) {
            return this.stream.reduce(z, mapper, folder);
        }

        public <R> R collect(Supplier<R> s, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
            return this.stream.collect(s, accumulator, combiner);
        }

        public long count() {
            return this.stream.count();
        }

        public boolean anyMatch(Predicate<? super T> p) {
            return this.stream.anyMatch(p);
        }

        public boolean allMatch(Predicate<? super T> p) {
            return this.stream.allMatch(p);
        }

        public boolean noneMatch(Predicate<? super T> predicate) {
            return this.stream.noneMatch(predicate);
        }

        public Optional<T> findAny() {
            return this.stream.findAny();
        }

        public CloseableIterator<T> iterator() {
            return Iterators.of(this.stream);
        }

        public CloseableSpliterator<T> spliterator() {
            return Iterators.spliterator(this.stream);
        }

        public void close() {
            this.isClosed = true;
        }
    }
}

