/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.CacheStream;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.object.DistinctOperation;
import org.infinispan.stream.impl.intops.object.FilterOperation;
import org.infinispan.stream.impl.intops.object.FlatMapOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToIntOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToLongOperation;
import org.infinispan.stream.impl.intops.object.LimitOperation;
import org.infinispan.stream.impl.intops.object.MapOperation;
import org.infinispan.stream.impl.intops.object.MapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.MapToIntOperation;
import org.infinispan.stream.impl.intops.object.MapToLongOperation;
import org.infinispan.stream.impl.intops.object.PeekOperation;
import org.infinispan.stream.impl.intops.object.SkipOperation;
import org.infinispan.stream.impl.intops.object.SortedComparatorOperation;
import org.infinispan.stream.impl.intops.object.SortedOperation;
import org.infinispan.stream.impl.termop.SingleRunOperation;
import org.infinispan.stream.impl.termop.object.ForEachOperation;
import org.infinispan.stream.impl.termop.object.NoMapIteratorOperation;
import org.infinispan.util.CloseableSuppliedIterator;
import org.infinispan.util.CloseableSupplier;
import org.infinispan.util.concurrent.TimeoutException;

public class DistributedCacheStream<R>
extends AbstractCacheStream<R, Stream<R>, Consumer<? super R>>
implements CacheStream<R> {
    protected static Supplier<CacheStream<CacheEntry>> supplierStreamCast(Supplier supplier) {
        return supplier;
    }

    public <K, V> DistributedCacheStream(Address localAddress, boolean parallel, DistributionManager dm, Supplier<CacheStream<CacheEntry<K, V>>> supplier, ClusterStreamManager csm, boolean includeLoader, int distributedBatchSize, Executor executor, ComponentRegistry registry) {
        super(localAddress, parallel, dm, DistributedCacheStream.supplierStreamCast(supplier), csm, includeLoader, distributedBatchSize, executor, registry);
    }

    public <K, V> DistributedCacheStream(Address localAddress, boolean parallel, DistributionManager dm, Supplier<CacheStream<CacheEntry<K, V>>> supplier, ClusterStreamManager csm, boolean includeLoader, int distributedBatchSize, Executor executor, ComponentRegistry registry, Function<? super CacheEntry<K, V>, R> function) {
        super(localAddress, parallel, dm, DistributedCacheStream.supplierStreamCast(supplier), csm, includeLoader, distributedBatchSize, executor, registry);
        this.intermediateOperations.add(new MapOperation<CacheEntry<K, V>, R>(function));
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
    }

    protected DistributedCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected Stream<R> unwrap() {
        return this;
    }

    @Override
    public Stream<R> filter(Predicate<? super R> predicate) {
        return (Stream)this.addIntermediateOperation(new FilterOperation<R>(predicate));
    }

    @Override
    public <R1> Stream<R1> map(Function<? super R, ? extends R1> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        return this.addIntermediateOperationMap(new MapOperation<R, R1>(mapper), this);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super R> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        return this.addIntermediateOperationMap(new MapToIntOperation<R>(mapper), this.intCacheStream());
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super R> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        return this.addIntermediateOperationMap(new MapToLongOperation<R>(mapper), this.longCacheStream());
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super R> mapper) {
        if (this.iteratorOperation != AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            this.iteratorOperation = AbstractCacheStream.IteratorOperation.MAP;
        }
        return this.addIntermediateOperationMap(new MapToDoubleOperation<R>(mapper), this.doubleCacheStream());
    }

    @Override
    public <R1> Stream<R1> flatMap(Function<? super R, ? extends Stream<? extends R1>> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperationMap(new FlatMapOperation(mapper), this);
    }

    @Override
    public IntStream flatMapToInt(Function<? super R, ? extends IntStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperationMap(new FlatMapToIntOperation<R>(mapper), this.intCacheStream());
    }

    @Override
    public LongStream flatMapToLong(Function<? super R, ? extends LongStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperationMap(new FlatMapToLongOperation<R>(mapper), this.longCacheStream());
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super R, ? extends DoubleStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperationMap(new FlatMapToDoubleOperation<R>(mapper), this.doubleCacheStream());
    }

    @Override
    public Stream<R> distinct() {
        DistinctOperation op = DistinctOperation.getInstance();
        this.markDistinct(op, AbstractCacheStream.IntermediateType.OBJ);
        return (Stream)this.addIntermediateOperation(op);
    }

    @Override
    public Stream<R> sorted() {
        this.markSorted(AbstractCacheStream.IntermediateType.OBJ);
        return (Stream)this.addIntermediateOperation(SortedOperation.getInstance());
    }

    @Override
    public Stream<R> sorted(Comparator<? super R> comparator) {
        this.markSorted(AbstractCacheStream.IntermediateType.OBJ);
        return (Stream)this.addIntermediateOperation(new SortedComparatorOperation<R>(comparator));
    }

    @Override
    public Stream<R> peek(Consumer<? super R> action) {
        return (Stream)this.addIntermediateOperation(new PeekOperation<R>(action));
    }

    @Override
    public Stream<R> limit(long maxSize) {
        LimitOperation op = new LimitOperation(maxSize);
        this.markDistinct(op, AbstractCacheStream.IntermediateType.OBJ);
        return (Stream)this.addIntermediateOperation(op);
    }

    @Override
    public Stream<R> skip(long n) {
        SkipOperation op = new SkipOperation(n);
        this.markSkip(AbstractCacheStream.IntermediateType.OBJ);
        return (Stream)this.addIntermediateOperation(op);
    }

    @Override
    public R reduce(R identity, BinaryOperator<R> accumulator) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, accumulator), true, accumulator, null);
    }

    @Override
    public Optional<R> reduce(BinaryOperator<R> accumulator) {
        R value = this.performOperation(TerminalFunctions.reduceFunction(accumulator), true, (e1, e2) -> {
            if (e1 != null) {
                if (e2 != null) {
                    return accumulator.apply(e1, e2);
                }
                return e1;
            }
            return e2;
        }, null);
        return Optional.ofNullable(value);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super R, U> accumulator, BinaryOperator<U> combiner) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, accumulator, combiner), true, combiner, null);
    }

    @Override
    public <R1> R1 collect(Supplier<R1> supplier, BiConsumer<R1, ? super R> accumulator, BiConsumer<R1, R1> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public <R1, A> R1 collect(Collector<? super R, A, R1> collector) {
        if (this.sorted) {
            boolean bl = this.sorted = !collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED);
        }
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return this.performOperation(TerminalFunctions.collectorFunction(collector), true, collector.combiner(), null, false);
        }
        Object intermediateResult = this.performOperation(TerminalFunctions.collectorFunction(new IdentifyFinishCollector<R, A>(collector)), true, collector.combiner(), null, false);
        return collector.finisher().apply(intermediateResult);
    }

    @Override
    public Optional<R> min(Comparator<? super R> comparator) {
        R value = this.performOperation(TerminalFunctions.minFunction(comparator), false, (e1, e2) -> {
            if (e1 != null) {
                if (e2 != null) {
                    return comparator.compare((Object)e1, (Object)e2) > 0 ? e2 : e1;
                }
                return e1;
            }
            return e2;
        }, null);
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<R> max(Comparator<? super R> comparator) {
        R value = this.performOperation(TerminalFunctions.maxFunction(comparator), false, (e1, e2) -> {
            if (e1 != null) {
                if (e2 != null) {
                    return comparator.compare((Object)e1, (Object)e2) > 0 ? e1 : e2;
                }
                return e1;
            }
            return e2;
        }, null);
        return Optional.ofNullable(value);
    }

    @Override
    public boolean anyMatch(Predicate<? super R> predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean allMatch(Predicate<? super R> predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(Predicate<? super R> predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public Optional<R> findFirst() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            Iterator<R> iterator = this.iterator();
            SingleRunOperation op = new SingleRunOperation(this.localIntermediateOperations, () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 4352), this.parallel), s -> s.findFirst());
            return op.performOperation();
        }
        return this.findAny();
    }

    @Override
    public Optional<R> findAny() {
        Object value = this.performOperation(TerminalFunctions.findAnyFunction(), false, (r1, r2) -> r1 == null ? r2 : r1, a -> a != null);
        return Optional.ofNullable(value);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countFunction(), true, (l1, l2) -> l1 + l2, null);
    }

    @Override
    public Iterator<R> iterator() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            return this.performIntermediateRemoteOperation(s -> s.iterator());
        }
        return this.remoteIterator();
    }

    Iterator<R> remoteIterator() {
        boolean iteratorParallelDistribute;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(this.distributedBatchSize);
        AtomicBoolean complete = new AtomicBoolean();
        ReentrantLock nextLock = new ReentrantLock();
        Condition nextCondition = nextLock.newCondition();
        HandOffConsumer consumer = new HandOffConsumer(queue, complete, nextLock, nextCondition);
        IteratorSupplier supplier = new IteratorSupplier(queue, complete, nextLock, nextCondition, this.csm);
        boolean bl = iteratorParallelDistribute = this.parallelDistribution == null ? false : this.parallelDistribution;
        if (this.rehashAware) {
            this.rehashAwareIteration(complete, consumer, supplier, iteratorParallelDistribute);
        } else {
            this.ignoreRehashIteration(consumer, supplier, iteratorParallelDistribute);
        }
        CloseableSuppliedIterator closeableIterator = new CloseableSuppliedIterator(supplier);
        this.onClose(() -> supplier.close());
        return closeableIterator;
    }

    private void ignoreRehashIteration(Consumer<R> consumer, IteratorSupplier<R> supplier, boolean iteratorParallelDistribute) {
        AbstractCacheStream.CollectionConsumer<R> remoteResults = new AbstractCacheStream.CollectionConsumer<R>(consumer);
        ConsistentHash ch = this.dm.getConsistentHash();
        boolean stayLocal = ch.getMembers().contains(this.localAddress) && this.segmentsToFilter != null && ch.getSegmentsForOwner(this.localAddress).containsAll(this.segmentsToFilter);
        NoMapIteratorOperation op = new NoMapIteratorOperation(this.intermediateOperations, this.supplierForSegments(ch, this.segmentsToFilter, null, !stayLocal), this.distributedBatchSize);
        Thread thread = Thread.currentThread();
        this.executor.execute(() -> {
            try {
                this.log.tracef("Thread %s submitted iterator request for stream", thread);
                Collection localValue = op.performOperation((KeyTrackingTerminalOperation.IntermediateCollector)remoteResults);
                remoteResults.onCompletion((Address)null, Collections.emptySet(), localValue);
                if (!stayLocal) {
                    UUID id;
                    iteratorSupplier.pending = id = this.csm.remoteStreamOperation(iteratorParallelDistribute, this.parallel, ch, this.segmentsToFilter, this.keysToFilter, Collections.emptyMap(), this.includeLoader, op, remoteResults);
                    try {
                        try {
                            if (!this.csm.awaitCompletion(id, 30L, TimeUnit.SECONDS)) {
                                throw new TimeoutException();
                            }
                        }
                        catch (InterruptedException e) {
                            throw new CacheException((Throwable)e);
                        }
                    }
                    finally {
                        this.csm.forgetOperation(id);
                    }
                }
                supplier.close();
            }
            catch (CacheException e) {
                this.log.trace("Encountered local cache exception for stream", e);
                supplier.close(e);
            }
            catch (Throwable t) {
                this.log.trace("Encountered local throwable for stream", t);
                supplier.close(new CacheException(t));
            }
        });
    }

    private void rehashAwareIteration(AtomicBoolean complete, Consumer<R> consumer, IteratorSupplier<R> supplier, boolean iteratorParallelDistribute) {
        SegmentListenerNotifier listenerNotifier;
        ConsistentHash segmentInfoCH = this.dm.getReadConsistentHash();
        if (this.segmentCompletionListener != null) {
            listenerNotifier = new SegmentListenerNotifier(this.segmentCompletionListener);
            supplier.setConsumer(listenerNotifier);
        } else {
            listenerNotifier = null;
        }
        AbstractCacheStream.KeyTrackingConsumer results = new AbstractCacheStream.KeyTrackingConsumer(segmentInfoCH, this.iteratorOperation.wrapConsumer(consumer), this.iteratorOperation.getFunction(), listenerNotifier);
        Thread thread = Thread.currentThread();
        this.executor.execute(() -> {
            try {
                this.log.tracef("Thread %s submitted iterator request for stream", thread);
                Set<Integer> segmentsToProcess = this.segmentsToFilter == null ? new ReplicatedConsistentHash.RangeSet(segmentInfoCH.getNumSegments()) : this.segmentsToFilter;
                do {
                    Set<Object> excludedKeys;
                    Set<Integer> segments;
                    ConsistentHash ch = this.dm.getReadConsistentHash();
                    boolean runLocal = ch.getMembers().contains(this.localAddress);
                    boolean stayLocal = false;
                    if (runLocal) {
                        Set<Integer> segmentsForOwner = ch.getSegmentsForOwner(this.localAddress);
                        stayLocal = this.segmentsToFilter != null && segmentsForOwner.containsAll(this.segmentsToFilter);
                        segments = stayLocal ? segmentsForOwner : ch.getPrimarySegmentsForOwner(this.localAddress);
                        segments.retainAll(segmentsToProcess);
                        excludedKeys = segments.stream().flatMap((? super T s) -> keyTrackingConsumer.referenceArray.get((int)s).stream()).collect(Collectors.toSet());
                    } else {
                        segments = null;
                        excludedKeys = Collections.emptySet();
                    }
                    KeyTrackingTerminalOperation op = this.iteratorOperation.getOperation(this.intermediateOperations, this.supplierForSegments(ch, segmentsToProcess, excludedKeys, !stayLocal), this.distributedBatchSize);
                    if (!stayLocal) {
                        UUID id;
                        iteratorSupplier.pending = id = this.csm.remoteStreamOperationRehashAware(iteratorParallelDistribute, this.parallel, ch, segmentsToProcess, this.keysToFilter, new AbstractCacheStream.AtomicReferenceArrayToMap(keyTrackingConsumer.referenceArray), this.includeLoader, op, results);
                        try {
                            if (runLocal) {
                                this.performLocalRehashAwareOperation(results, segmentsToProcess, ch, segments, op, () -> ch.getPrimarySegmentsForOwner(this.localAddress), id);
                            }
                            try {
                                if (!this.csm.awaitCompletion(id, 30L, TimeUnit.SECONDS)) {
                                    throw new TimeoutException();
                                }
                            }
                            catch (InterruptedException e) {
                                throw new CacheException((Throwable)e);
                            }
                            segmentsToProcess = this.segmentsToProcess(supplier, results, segmentsToProcess, id);
                        }
                        finally {
                            this.csm.forgetOperation(id);
                        }
                    }
                    this.performLocalRehashAwareOperation(results, segmentsToProcess, ch, segments, op, () -> ch.getSegmentsForOwner(this.localAddress), null);
                    segmentsToProcess = this.segmentsToProcess(supplier, results, segmentsToProcess, null);
                } while (!complete.get());
            }
            catch (CacheException e) {
                this.log.trace("Encountered local cache exception for stream", e);
                supplier.close(e);
            }
            catch (Throwable t) {
                this.log.trace("Encountered local throwable for stream", t);
                supplier.close(new CacheException(t));
            }
        });
    }

    private Set<Integer> segmentsToProcess(IteratorSupplier<R> supplier, AbstractCacheStream.KeyTrackingConsumer<Object, R> results, Set<Integer> segmentsToProcess, UUID id) {
        String strId;
        String string = strId = id == null ? "local" : id.toString();
        if (!results.lostSegments.isEmpty()) {
            segmentsToProcess = new HashSet<Integer>(results.lostSegments);
            results.lostSegments.clear();
            this.log.tracef("Found %s lost segments for %s", segmentsToProcess, strId);
        } else {
            supplier.close();
            this.log.tracef("Finished rehash aware operation for %s", strId);
        }
        return segmentsToProcess;
    }

    private void performLocalRehashAwareOperation(AbstractCacheStream.KeyTrackingConsumer<Object, R> results, Set<Integer> segmentsToProcess, ConsistentHash ch, Set<Integer> segments, KeyTrackingTerminalOperation<Object, R, Object> op, Supplier<Set<Integer>> ownedSegmentsSupplier, UUID id) {
        Collection localValue = op.performOperationRehashAware(results);
        if (this.dm.getReadConsistentHash().equals(ch)) {
            this.log.tracef("Found local values %s for id %s", localValue.size(), id);
            results.onCompletion((Address)null, segments, localValue);
        } else {
            Set<Integer> ourSegments = ownedSegmentsSupplier.get();
            ourSegments.retainAll(segmentsToProcess);
            this.log.tracef("CH changed - making %s segments suspect for identifier %s", ourSegments, id);
            results.onSegmentsLost(ourSegments);
        }
    }

    @Override
    public Spliterator<R> spliterator() {
        return Spliterators.spliterator(this.iterator(), Long.MAX_VALUE, 4096);
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashForEach(action);
        }
    }

    @Override
    KeyTrackingTerminalOperation getForEach(Consumer<? super R> consumer, Supplier<Stream<CacheEntry>> supplier) {
        return new ForEachOperation(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
    }

    @Override
    public void forEachOrdered(Consumer<? super R> action) {
        if (this.sorted) {
            Iterator<R> iterator = this.iterator();
            SingleRunOperation op = new SingleRunOperation(this.localIntermediateOperations, () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 4352), this.parallel), s -> {
                s.forEachOrdered(action);
                return null;
            });
            op.performOperation();
        } else {
            this.forEach(action);
        }
    }

    @Override
    public Object[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayFunction(), false, (v1, v2) -> {
            Object[] array = Arrays.copyOf(v1, ((Object[])v1).length + ((Object[])v2).length);
            System.arraycopy(v2, 0, array, ((Object[])v1).length, ((Object[])v2).length);
            return array;
        }, null, false);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.performOperation(TerminalFunctions.toArrayFunction(generator), false, (v1, v2) -> {
            Object[] array = (Object[])generator.apply(((Object[])v1).length + ((Object[])v2).length);
            System.arraycopy(v1, 0, array, 0, ((Object[])v1).length);
            System.arraycopy(v2, 0, array, ((Object[])v1).length, ((Object[])v2).length);
            return array;
        }, null, false);
    }

    @Override
    public CacheStream<R> sequentialDistribution() {
        this.parallelDistribution = false;
        return this;
    }

    @Override
    public CacheStream<R> parallelDistribution() {
        this.parallelDistribution = true;
        return this;
    }

    @Override
    public CacheStream<R> filterKeySegments(Set<Integer> segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public CacheStream<R> filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public CacheStream<R> distributedBatchSize(int batchSize) {
        this.distributedBatchSize = batchSize;
        return this;
    }

    @Override
    public CacheStream<R> segmentCompletionListener(CacheStream.SegmentCompletionListener listener) {
        this.segmentCompletionListener = this.segmentCompletionListener == null ? listener : DistributedCacheStream.composeWithExceptions(this.segmentCompletionListener, listener);
        return this;
    }

    @Override
    public CacheStream<R> disableRehashAware() {
        this.rehashAware = false;
        return this;
    }

    protected DistributedIntCacheStream intCacheStream() {
        return new DistributedIntCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    protected static CacheStream.SegmentCompletionListener composeWithExceptions(CacheStream.SegmentCompletionListener a, CacheStream.SegmentCompletionListener b) {
        return segments -> {
            try {
                a.segmentCompleted(segments);
            }
            catch (Throwable e1) {
                try {
                    b.segmentCompleted(segments);
                }
                catch (Throwable e2) {
                    try {
                        e1.addSuppressed(e2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e1;
            }
            b.segmentCompleted(segments);
        };
    }

    static class IteratorSupplier<R>
    implements CloseableSupplier<R> {
        private final BlockingQueue<R> queue;
        private final AtomicBoolean completed;
        private final Lock nextLock;
        private final Condition nextCondition;
        private final ClusterStreamManager<?> clusterStreamManager;
        CacheException exception;
        volatile UUID pending;
        private Consumer<R> consumer;

        IteratorSupplier(BlockingQueue<R> queue, AtomicBoolean completed, Lock nextLock, Condition nextCondition, ClusterStreamManager<?> clusterStreamManager) {
            this.queue = queue;
            this.completed = completed;
            this.nextLock = nextLock;
            this.nextCondition = nextCondition;
            this.clusterStreamManager = clusterStreamManager;
        }

        @Override
        public void close() {
            this.close(null);
        }

        public void close(CacheException e) {
            this.nextLock.lock();
            try {
                if (!this.completed.getAndSet(true) && e != null) {
                    this.exception = e;
                }
                if (this.pending != null) {
                    this.clusterStreamManager.forgetOperation(this.pending);
                    this.pending = null;
                }
                this.nextCondition.signalAll();
            }
            finally {
                this.nextLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R get() {
            Object entry = this.queue.poll();
            if (entry == null) {
                if (this.completed.get()) {
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return null;
                }
                this.nextLock.lock();
                try {
                    boolean interrupted = false;
                    while ((entry = this.queue.poll()) == null && !this.completed.get()) {
                        try {
                            this.nextCondition.await(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    if (entry == null) {
                        if (this.exception != null) {
                            throw this.exception;
                        }
                        R r = null;
                        return r;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    this.nextLock.unlock();
                }
            }
            if (this.consumer != null && entry != null) {
                this.consumer.accept(entry);
            }
            return (R)entry;
        }

        public void setConsumer(Consumer<R> consumer) {
            this.consumer = consumer;
        }
    }

    static class SegmentListenerNotifier<T>
    implements Consumer<T> {
        private final CacheStream.SegmentCompletionListener listener;
        private final Map<T, Set<Integer>> segmentsByObject = new IdentityHashMap<T, Set<Integer>>();

        SegmentListenerNotifier(CacheStream.SegmentCompletionListener listener) {
            this.listener = listener;
        }

        @Override
        public void accept(T t) {
            Set<Integer> segments = this.segmentsByObject.remove(t);
            if (segments != null) {
                this.listener.segmentCompleted(segments);
            }
        }

        public void addSegmentsForObject(T object, Set<Integer> segments) {
            this.segmentsByObject.put(object, segments);
        }

        public void completeSegmentsNoResults(Set<Integer> segments) {
            this.listener.segmentCompleted(segments);
        }
    }

    static class HandOffConsumer<R>
    implements Consumer<R> {
        private final BlockingQueue<R> queue;
        private final AtomicBoolean completed;
        private final Lock nextLock;
        private final Condition nextCondition;

        HandOffConsumer(BlockingQueue<R> queue, AtomicBoolean completed, Lock nextLock, Condition nextCondition) {
            this.queue = queue;
            this.completed = completed;
            this.nextLock = nextLock;
            this.nextCondition = nextCondition;
        }

        @Override
        public void accept(R rs) {
            if (!this.queue.offer(rs) && !this.completed.get()) {
                this.nextLock.lock();
                try {
                    this.nextCondition.signalAll();
                }
                finally {
                    this.nextLock.unlock();
                }
                while (!this.completed.get()) {
                    try {
                        if (!this.queue.offer(rs, 100L, TimeUnit.MILLISECONDS)) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new CacheException((Throwable)e);
                    }
                }
            }
        }
    }

    @SerializeWith(value=IdentityFinishCollectorExternalizer.class)
    private static final class IdentifyFinishCollector<T, A>
    implements Collector<T, A, A> {
        private final Collector<T, A, ?> realCollector;

        IdentifyFinishCollector(Collector<T, A, ?> realCollector) {
            this.realCollector = realCollector;
        }

        @Override
        public Supplier<A> supplier() {
            return this.realCollector.supplier();
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.realCollector.accumulator();
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.realCollector.combiner();
        }

        @Override
        public Function<A, A> finisher() {
            return null;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            Set<Collector.Characteristics> characteristics = this.realCollector.characteristics();
            if (characteristics.size() == 0) {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
            EnumSet<Collector.Characteristics> tweaked = EnumSet.copyOf(characteristics);
            tweaked.add(Collector.Characteristics.IDENTITY_FINISH);
            return tweaked;
        }

        public static final class IdentityFinishCollectorExternalizer
        implements Externalizer<IdentifyFinishCollector> {
            public void writeObject(ObjectOutput output, IdentifyFinishCollector object) throws IOException {
                output.writeObject(object.realCollector);
            }

            public IdentifyFinishCollector readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new IdentifyFinishCollector((Collector)input.readObject());
            }
        }
    }
}

