/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.infinispan.objectfilter.impl.aggregation.DoubleSum;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

final class SumAccumulator
extends FieldAccumulator {
    private final Class<? extends Number> fieldType;

    public SumAccumulator(int inPos, int outPos, Class<?> fieldType) {
        super(inPos, outPos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation SUM cannot be applied to property of type " + fieldType.getName());
        }
        this.fieldType = fieldType;
    }

    @Override
    public void init(Object[] accRow) {
        if (this.fieldType == Double.class || this.fieldType == Float.class) {
            accRow[this.outPos] = new DoubleSum();
        }
    }

    @Override
    public void update(Object[] srcRow, Object[] accRow) {
        Number value = (Number)srcRow[this.inPos];
        if (value != null) {
            if (this.fieldType == Double.class || this.fieldType == Float.class) {
                ((DoubleSum)accRow[this.outPos]).update(value.doubleValue());
            } else if (this.fieldType == Integer.class || this.fieldType == Byte.class || this.fieldType == Short.class) {
                value = value.longValue();
                Number sum = (Number)accRow[this.outPos];
                if (sum != null) {
                    value = this.fieldType == Long.class ? (Number)(sum.longValue() + value.longValue()) : (Number)(this.fieldType == BigInteger.class ? ((BigInteger)sum).add((BigInteger)value) : (this.fieldType == BigDecimal.class ? ((BigDecimal)sum).add((BigDecimal)value) : Integer.valueOf(sum.intValue() + value.intValue())));
                }
                accRow[this.outPos] = value;
            }
        }
    }

    @Override
    public void finish(Object[] accRow) {
        if (this.fieldType == Double.class || this.fieldType == Float.class) {
            accRow[this.outPos] = ((DoubleSum)accRow[this.outPos]).getValue();
        }
    }

    static Class<?> getOutputType(Class<?> fieldType) {
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation SUM cannot be applied to property of type " + fieldType.getName());
        }
        if (fieldType == Double.class || fieldType == Float.class) {
            return Double.class;
        }
        if (fieldType == Long.class || fieldType == Integer.class || fieldType == Byte.class || fieldType == Short.class) {
            return Long.class;
        }
        return fieldType;
    }
}

