/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.Either;
import org.infinispan.commons.util.ReflectionUtil;

public class AddClientListenerOperation
extends RetryOnFailureOperation<Short> {
    private static final Log log = LogFactory.getLog(AddClientListenerOperation.class, Log.class);
    public final byte[] listenerId = this.generateListenerId();
    private final String cacheNameString;
    private Transport dedicatedTransport;
    private final ClientListenerNotifier listenerNotifier;
    public final Object listener;
    public final byte[][] filterFactoryParams;
    public final byte[][] converterFactoryParams;

    protected AddClientListenerOperation(Codec codec, TransportFactory transportFactory, String cacheName, AtomicInteger topologyId, Flag[] flags, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super(codec, transportFactory, RemoteCacheManager.cacheNameBytes(cacheName), topologyId, flags);
        this.listenerNotifier = listenerNotifier;
        this.listener = listener;
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
        this.cacheNameString = cacheName;
    }

    private byte[] generateListenerId() {
        UUID uuid = UUID.randomUUID();
        byte[] listenerId = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(listenerId);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return listenerId;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        this.dedicatedTransport = this.transportFactory.getTransport(failedServers, this.cacheName);
        return this.dedicatedTransport;
    }

    @Override
    protected void releaseTransport(Transport transport) {
    }

    public Transport getDedicatedTransport() {
        return this.dedicatedTransport;
    }

    @Override
    protected Short executeOperation(Transport transport) {
        Either<Short, ClientEvent> either;
        ClientListener clientListener = this.extractClientListener();
        HeaderParams params = this.writeHeader(transport, (short)37);
        transport.writeArray(this.listenerId);
        this.codec.writeClientListenerParams(transport, clientListener, this.filterFactoryParams, this.converterFactoryParams);
        transport.flush();
        this.listenerNotifier.addClientListener(this);
        do {
            either = this.codec.readHeaderOrEvent(this.dedicatedTransport, params, this.listenerId, this.listenerNotifier.getMarshaller());
            switch (either.type()) {
                case LEFT: {
                    if ((Short)either.left() == 0) {
                        this.listenerNotifier.startClientListener(this.listenerId);
                        break;
                    }
                    this.listenerNotifier.removeClientListener(this.listenerId);
                    break;
                }
                case RIGHT: {
                    this.listenerNotifier.invokeEvent(this.listenerId, (ClientEvent)either.right());
                }
            }
        } while (either.type() == Either.Type.RIGHT);
        return (Short)either.left();
    }

    private ClientListener extractClientListener() {
        ClientListener l = (ClientListener)ReflectionUtil.getAnnotation(this.listener.getClass(), ClientListener.class);
        if (l == null) {
            throw log.missingClientListenerAnnotation(this.listener.getClass().getName());
        }
        return l;
    }

    public String getCacheName() {
        return this.cacheNameString;
    }
}

