/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import javax.transaction.TransactionManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lucene.impl.CommonLockObtainUtils;
import org.infinispan.lucene.impl.DirectoryLucene;
import org.infinispan.lucene.impl.TransactionalSharedLuceneLock;

public class TransactionalLockFactory
extends LockFactory {
    public static final TransactionalLockFactory INSTANCE = new TransactionalLockFactory();

    public TransactionalSharedLuceneLock obtainLock(Directory dir, String lockName) throws IOException {
        if (!(dir instanceof DirectoryLucene)) {
            throw new UnsupportedOperationException("TransactionalSharedLuceneLock can only be used with DirectoryLucene, got: " + dir);
        }
        DirectoryLucene infinispanDirectory = (DirectoryLucene)dir;
        Cache<Object, Integer> cache = infinispanDirectory.getDistLockCache();
        String indexName = infinispanDirectory.getIndexName();
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        if (tm == null) {
            ComponentStatus status = cache.getAdvancedCache().getComponentRegistry().getStatus();
            if (status.equals((Object)ComponentStatus.RUNNING)) {
                throw new CacheException("Failed looking up TransactionManager. Check if any transaction manager is associated with Infinispan cache: '" + cache.getName() + "'");
            }
            throw new CacheException("Failed looking up TransactionManager: the cache is not running");
        }
        TransactionalSharedLuceneLock lock = new TransactionalSharedLuceneLock(cache, indexName, lockName, tm);
        CommonLockObtainUtils.attemptObtain(lock);
        return lock;
    }
}

