/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class JGroupsMasterMessageListener
implements Receiver {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final BuildContext context;
    private final NodeSelectorService selector;

    public JGroupsMasterMessageListener(BuildContext context, NodeSelectorService masterNodeSelector) {
        this.context = context;
        this.selector = masterNodeSelector;
    }

    public void receive(Message message) {
        int offset = message.getOffset();
        int bufferLength = message.getLength();
        byte[] rawBuffer = message.getRawBuffer();
        String indexName = MessageSerializationHelper.extractIndexName(offset, rawBuffer);
        NodeSelectorStrategy nodeSelector = this.selector.getMasterNodeSelector(indexName);
        try {
            if (nodeSelector != null && nodeSelector.isIndexOwnerLocal()) {
                byte[] serializedQueue = MessageSerializationHelper.extractSerializedQueue(offset, bufferLength, rawBuffer);
                IndexManager indexManager = this.context.getAllIndexesManager().getIndexManager(indexName);
                if (indexManager != null) {
                    List queue = indexManager.getSerializer().toLuceneWorks(serializedQueue);
                    this.applyLuceneWorkLocally(queue, indexManager, message);
                } else {
                    log.messageReceivedForUndefinedIndex(indexName);
                }
            }
        }
        catch (ClassCastException e) {
            log.illegalObjectRetrievedFromMessage(e);
        }
        catch (SearchException e) {
            log.illegalObjectRetrievedFromMessage((Exception)((Object)e));
        }
    }

    private void applyLuceneWorkLocally(List<LuceneWork> queue, IndexManager indexManager, Message message) {
        if (queue != null && !queue.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("There are %d Lucene docs received from slave node %s to be processed by master", queue.size(), message.getSrc());
            }
            indexManager.performOperations(queue, null);
        } else {
            log.receivedEmptyLuceneWorksInMessage();
        }
    }

    public void viewAccepted(View view) {
        log.jGroupsReceivedNewClusterView(view);
        this.selector.viewAccepted(view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void getState(OutputStream arg0) throws Exception {
    }

    public void setState(InputStream arg0) throws Exception {
    }

    public void unblock() {
    }
}

