/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;

public abstract class CacheSupport<K, V>
implements BasicCache<K, V> {
    protected long defaultLifespan;
    protected long defaultMaxIdleTime;

    protected CacheSupport() {
        this(0L, 0L);
    }

    protected CacheSupport(long defaultLifespan, long defaultMaxIdleTime) {
        this.defaultLifespan = defaultLifespan;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    public final V put(K key, V value) {
        return (V)this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    protected abstract void set(K var1, V var2);

    public final void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value) {
        return (V)this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.put(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.putIfAbsent(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.replace(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value) {
        return (V)this.replace(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }
}

