/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.spi;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DirectoryHelper {
    private static final Log log = LoggerFactory.make();

    private DirectoryHelper() {
    }

    public static void initializeIndexIfNeeded(Directory directory) {
        try (SimpleAnalyzer analyzer = new SimpleAnalyzer();){
            if (!DirectoryReader.indexExists((Directory)directory)) {
                try {
                    IndexWriterConfig iwriterConfig = new IndexWriterConfig((Analyzer)analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                    iwriterConfig.setWriteLockTimeout(2000L);
                    IndexWriter iw = new IndexWriter(directory, iwriterConfig);
                    iw.close();
                }
                catch (LockObtainFailedException lofe) {
                    log.lockingFailureDuringInitialization(directory.toString());
                }
            }
        }
    }

    public static Path getVerifiedIndexPath(String annotatedIndexName, Properties properties, boolean verifyIsWritable) {
        String indexBase = properties.getProperty("indexBase", ".");
        String indexName = properties.getProperty("indexName", annotatedIndexName);
        Path baseIndexDir = FileSystems.getDefault().getPath(indexBase, new String[0]);
        DirectoryProviderHelper.makeSanityCheckedDirectory(baseIndexDir, indexName, verifyIsWritable);
        Path indexDir = baseIndexDir.resolve(indexName);
        DirectoryProviderHelper.makeSanityCheckedDirectory(indexDir, indexName, verifyIsWritable);
        return indexDir;
    }

    @Deprecated
    public static File getVerifiedIndexDir(String annotatedIndexName, Properties properties, boolean verifyIsWritable) {
        return DirectoryHelper.getVerifiedIndexPath(annotatedIndexName, properties, verifyIsWritable).toFile();
    }
}

