/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ReadWriteKeyValueCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteKeyValueCommand.class);
    public static final byte COMMAND_ID = 51;
    private V value;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;
    private V prevValue;
    private Metadata prevMetadata;

    public ReadWriteKeyValueCommand(K key, V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params) {
        super(key, valueMatcher, id, params);
        this.value = value;
        this.f = f;
    }

    public ReadWriteKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 51;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
        output.writeObject(this.commandInvocationId);
        output.writeObject(this.prevValue);
        output.writeObject(this.prevMetadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.f = (BiFunction)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.flags = (Set)input.readObject();
        this.commandInvocationId = (CommandInvocationId)input.readObject();
        this.prevValue = input.readObject();
        this.prevMetadata = (Metadata)input.readObject();
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        if (this.prevValue == null && !this.hasFlag(Flag.COMMAND_RETRY)) {
            this.prevValue = e.getValue();
            this.prevMetadata = e.getMetadata();
        }
        if (this.valueUnchanged(e, this.prevValue, this.value) || this.valueRemoved(e, this.prevValue)) {
            log.tracef("Execute read-write function on previous value %s and previous metadata %s", this.prevValue, this.prevMetadata);
            R ret = this.f.apply(this.value, EntryViews.readWrite(e, this.prevValue, this.prevMetadata));
            return EntryViews.snapshot(ret);
        }
        return this.f.apply(this.value, EntryViews.readWrite(e, e.getValue(), e.getMetadata()));
    }

    boolean valueRemoved(MVCCEntry<K, V> e, V prevValue) {
        return this.valueUnchanged(e, prevValue, null);
    }

    boolean valueUnchanged(MVCCEntry<K, V> e, V prevValue, V value) {
        return this.valueMatcher.matches(e, prevValue, value, (Equivalence)AnyEquivalence.getInstance());
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyValueCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr(this.value) + ", prevValue=" + Util.toStr(this.prevValue) + ", prevMetadata=" + Util.toStr((Object)this.prevMetadata) + ", flags=" + this.flags + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", successful=" + this.successful + "}";
    }
}

