/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Properties;
import java.util.Set;
import org.infinispan.query.indexmanager.InfinispanIndexManager;

public final class IndexPropertyInspector {
    private IndexPropertyInspector() {
    }

    public static String getLockingCacheName(Properties properties) {
        return IndexPropertyInspector.getPropertyFor("locking_cachename", properties, "LuceneIndexesLocking");
    }

    public static String getDataCacheName(Properties properties) {
        return IndexPropertyInspector.getPropertyFor("data_cachename", properties, "LuceneIndexesData");
    }

    public static String getMetadataCacheName(Properties properties) {
        return IndexPropertyInspector.getPropertyFor("metadata_cachename", properties, "LuceneIndexesMetadata");
    }

    public static boolean hasInfinispanDirectory(Properties properties) {
        String indexManager = IndexPropertyInspector.getPropertyFor("indexmanager", properties, null);
        String directoryProvider = IndexPropertyInspector.getPropertyFor("directory_provider", properties, null);
        return "infinispan".equals(directoryProvider) || InfinispanIndexManager.class.getName().equals(indexManager);
    }

    private static String getPropertyFor(String suffix, Properties properties, String defaultValue) {
        Set<String> propertyNames = properties.stringPropertyNames();
        String propertyValue = null;
        for (String propertyName : propertyNames) {
            if (!propertyName.endsWith(suffix)) continue;
            propertyValue = properties.getProperty(propertyName);
        }
        return propertyValue == null ? defaultValue : propertyValue;
    }
}

