/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.BaseEmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;

final class EmbeddedQuery
extends BaseEmbeddedQuery {
    private final QueryEngine queryEngine;
    private JPAFilterAndConverter<?, ?> filter;

    EmbeddedQuery(QueryEngine queryEngine, QueryFactory queryFactory, AdvancedCache<?, ?> cache, String jpaQuery, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, cache, jpaQuery, namedParameters, projection, startOffset, maxResults);
        this.queryEngine = queryEngine;
    }

    @Override
    public void resetQuery() {
        super.resetQuery();
        this.filter = null;
    }

    private JPAFilterAndConverter<?, ?> createFilter() {
        if (this.filter == null) {
            this.filter = this.queryEngine.makeFilter(this.jpaQuery, this.namedParameters);
            this.filter.getObjectFilter();
        }
        return this.filter;
    }

    private CloseableIterator<Map.Entry<?, ObjectFilter.FilterResult>> createFilteredIterator() {
        JPAFilterAndConverter<?, ?> f = this.createFilter();
        return this.cache.filterEntries(f).converter(f).iterator();
    }

    @Override
    protected Comparator<Comparable[]> getComparator() {
        return this.createFilter().getObjectFilter().getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getIterator() {
        return new CloseableIterator<ObjectFilter.FilterResult>(){
            private final CloseableIterator<Map.Entry<?, ObjectFilter.FilterResult>> it;
            {
                this.it = EmbeddedQuery.this.createFilteredIterator();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public ObjectFilter.FilterResult next() {
                return (ObjectFilter.FilterResult)((Map.Entry)this.it.next()).getValue();
            }

            public void close() {
                this.it.close();
            }
        };
    }

    @Override
    public String toString() {
        return "EmbeddedQuery{jpaQuery=" + this.jpaQuery + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

