/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.metadata.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.FieldSettingsDescriptor;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FieldDescriptorImpl
implements FieldDescriptor {
    private static final Log log = LoggerFactory.make();
    private final String name;
    private final Index index;
    private final Analyze analyze;
    private final Store store;
    private final TermVector termVector;
    private final Norms norms;
    private final float boost;
    private final String indexNullAs;
    private final Analyzer analyzer;
    private final FieldBridge fieldBridge;
    private final FieldSettingsDescriptor.Type fieldType;

    public FieldDescriptorImpl(DocumentFieldMetadata documentFieldMetadata) {
        this.name = documentFieldMetadata.getName();
        this.index = this.determineIndexType(documentFieldMetadata.getIndex());
        this.analyze = this.determineAnalyzeType(documentFieldMetadata.getIndex());
        this.store = documentFieldMetadata.getStore();
        this.termVector = this.determineTermVectorType(documentFieldMetadata.getTermVector());
        this.norms = this.determineNormsType(documentFieldMetadata.getIndex());
        this.boost = documentFieldMetadata.getBoost().floatValue();
        this.indexNullAs = documentFieldMetadata.indexNullAs();
        this.analyzer = this.initAnalyzer(documentFieldMetadata);
        this.fieldBridge = documentFieldMetadata.getFieldBridge();
        this.fieldType = this.determineFieldType(documentFieldMetadata);
    }

    private Analyzer initAnalyzer(DocumentFieldMetadata documentFieldMetadata) {
        if (documentFieldMetadata.getAnalyzerReference() != null && documentFieldMetadata.getAnalyzerReference().is(LuceneAnalyzerReference.class)) {
            return documentFieldMetadata.getAnalyzerReference().unwrap(LuceneAnalyzerReference.class).getAnalyzer();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public Analyze getAnalyze() {
        return this.analyze;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public TermVector getTermVector() {
        return this.termVector;
    }

    @Override
    public Norms getNorms() {
        return this.norms;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public FieldSettingsDescriptor.Type getType() {
        return this.fieldType;
    }

    @Override
    public <T extends FieldSettingsDescriptor> T as(Class<T> type) {
        if (this.fieldType == FieldSettingsDescriptor.Type.NUMERIC && type == NumericFieldSettingsDescriptor.class) {
            return (T)((FieldSettingsDescriptor)type.cast(this));
        }
        throw log.getUnableToNarrowFieldDescriptorException(this.getClass().getName(), this.fieldType.toString(), type == null ? "null" : type.getName());
    }

    @Override
    public String indexNullAs() {
        return this.indexNullAs;
    }

    @Override
    public boolean indexNull() {
        return this.indexNullAs != null;
    }

    @Override
    public FieldBridge getFieldBridge() {
        return this.fieldBridge;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldDescriptorImpl{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", index=").append((Object)this.index);
        sb.append(", analyze=").append((Object)this.analyze);
        sb.append(", store=").append((Object)this.store);
        sb.append(", termVector=").append((Object)this.termVector);
        sb.append(", norms=").append((Object)this.norms);
        sb.append(", boost=").append(this.boost);
        sb.append(", indexNullAs='").append(this.indexNullAs).append('\'');
        sb.append(", analyzer=").append(this.analyzer);
        sb.append(", fieldBridge=").append(this.fieldBridge);
        sb.append(", fieldType=").append((Object)this.fieldType);
        sb.append('}');
        return sb.toString();
    }

    private FieldSettingsDescriptor.Type determineFieldType(DocumentFieldMetadata documentFieldMetadata) {
        if (documentFieldMetadata.isNumeric()) {
            return FieldSettingsDescriptor.Type.NUMERIC;
        }
        if (documentFieldMetadata.isSpatial()) {
            return FieldSettingsDescriptor.Type.SPATIAL;
        }
        return FieldSettingsDescriptor.Type.BASIC;
    }

    private Index determineIndexType(Field.Index index) {
        if (Field.Index.NO.equals((Object)index)) {
            return Index.NO;
        }
        return Index.YES;
    }

    private Analyze determineAnalyzeType(Field.Index index) {
        if (Field.Index.ANALYZED.equals((Object)index) || Field.Index.ANALYZED_NO_NORMS.equals((Object)index)) {
            return Analyze.YES;
        }
        return Analyze.NO;
    }

    private Norms determineNormsType(Field.Index index) {
        if (Field.Index.ANALYZED.equals((Object)index) || Field.Index.NOT_ANALYZED.equals((Object)index)) {
            return Norms.YES;
        }
        return Norms.NO;
    }

    private TermVector determineTermVectorType(Field.TermVector termVector) {
        switch (termVector) {
            case NO: {
                return TermVector.NO;
            }
            case YES: {
                return TermVector.YES;
            }
            case WITH_POSITIONS: {
                return TermVector.WITH_POSITIONS;
            }
            case WITH_OFFSETS: {
                return TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS_OFFSETS: {
                return TermVector.WITH_POSITION_OFFSETS;
            }
        }
        throw new SearchException("Unknown term vector type");
    }
}

