/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import io.searchbox.client.JestResult;
import java.util.List;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BulkRequestFailedException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends org.hibernate.search.util.logging.impl.Log {
    @Message(id=400001, value="Cannot execute query '%2$s', as targeted entity type '%1$s' is not mapped to an Elasticsearch index")
    public SearchException cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=400002, value="Lucene query '%1$s' cannot be transformed into equivalent Elasticsearch query")
    public SearchException cannotTransformLuceneQueryIntoEsQuery(Query var1);

    @Message(id=400003, value="Lucene filter '%1$s' cannot be transformed into equivalent Elasticsearch query")
    public SearchException cannotTransformLuceneFilterIntoEsQuery(Filter var1);

    @Message(id=400004, value="The sort order RANGE_DEFINITION_ORDER cant not be sent used with Elasticsearch")
    public SearchException cannotSendRangeDefinitionOrderToElasticsearchBackend();

    @Message(id=400005, value="The SortType '%1$s' cannot be used with a null sort field name")
    public SearchException cannotUseThisSortTypeWithNullSortFieldName(SortField.Type var1);

    @Message(id=400006, value="Empty phrase queries are not supported")
    public SearchException cannotQueryOnEmptyPhraseQuery();

    @Message(id=400007, value="Elasticsearch request failed.\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearchRequestFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=400008, value="Elasticsearch request failed.\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public BulkRequestFailedException elasticsearchBulkRequestFailed(String var1, String var2, @Param List<BackendRequest<? extends JestResult>> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400009, value="Field '%2$s' in '%1$s' requires a remote analyzer reference (got '%3$s' instead). The analyzer will be ignored.")
    public void analyzerIsNotRemote(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, AnalyzerReference var3);

    @Message(id=400010, value="Elasticsearch connection time-out; check the cluster status, it should be 'green';\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearchRequestTimeout(String var1, String var2);

    @Message(id=400011, value="Projection of non-JSON-primitive field values is not supported: '%1$s'")
    public SearchException unsupportedProjectionOfNonJsonPrimitiveFields(JsonElement var1);
}

