/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedRangeMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedTermMatchingContext;

class MatchingContextSupport {
    QueryBuilder builder;
    FieldBridge fieldBridge;
    String propertyName;

    MatchingContextSupport(QueryBuilder builder, FieldBridge fieldBridge, String propertyName) {
        this.builder = builder;
        this.fieldBridge = fieldBridge;
        this.propertyName = propertyName;
    }

    TermMatchingContext keyWordTermMatchingContext() {
        if (this.fieldBridge != null) {
            return (TermMatchingContext)((ConnectedTermMatchingContext)this.builder.keyword().onField(this.propertyName)).withFieldBridge(this.fieldBridge).ignoreAnalyzer();
        }
        return this.builder.keyword().onField(this.propertyName);
    }

    TermMatchingContext wildcardTermMatchingContext() {
        if (this.fieldBridge != null) {
            return (TermMatchingContext)((ConnectedTermMatchingContext)this.builder.keyword().wildcard().onField(this.propertyName)).withFieldBridge(this.fieldBridge).ignoreAnalyzer();
        }
        return this.builder.keyword().wildcard().onField(this.propertyName);
    }

    RangeMatchingContext rangeMatchingContext() {
        if (this.fieldBridge != null) {
            return (RangeMatchingContext)((ConnectedRangeMatchingContext)this.builder.range().onField(this.propertyName)).withFieldBridge(this.fieldBridge).ignoreAnalyzer();
        }
        return this.builder.range().onField(this.propertyName);
    }
}

