/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter;

import java.util.Collections;
import java.util.List;
import org.hibernate.hql.ast.origin.hql.resolve.path.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.jboss.logging.Logger;

public final class PropertyPath {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)PropertyPath.class.getName());
    private final AggregationType aggregationType;
    private final List<String> path;

    public PropertyPath(AggregationType aggregationType, List<String> path) {
        this.aggregationType = aggregationType;
        this.path = path;
    }

    public PropertyPath(AggregationType aggregationType, String propertyName) {
        this(aggregationType, Collections.singletonList(propertyName));
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public List<String> getPath() {
        return this.path;
    }

    public String asStringPath() {
        if (this.path.isEmpty()) {
            return null;
        }
        return StringHelper.join(this.path, ".");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != PropertyPath.class) {
            return false;
        }
        PropertyPath that = (PropertyPath)o;
        return this.aggregationType == that.aggregationType && this.path.equals(that.path);
    }

    public int hashCode() {
        return 31 * (this.aggregationType != null ? this.aggregationType.hashCode() : 0) + this.path.hashCode();
    }

    public String toString() {
        return this.aggregationType != null ? this.aggregationType.name() + '(' + StringHelper.join(this.path, ".") + ')' : StringHelper.join(this.path, ".");
    }

    public static enum AggregationType {
        SUM,
        AVG,
        MIN,
        MAX,
        COUNT;


        public static AggregationType from(AggregationPropertyPath.Type aggregationType) {
            if (aggregationType == null) {
                return null;
            }
            switch (aggregationType) {
                case SUM: {
                    return SUM;
                }
                case AVG: {
                    return AVG;
                }
                case MIN: {
                    return MIN;
                }
                case MAX: {
                    return MAX;
                }
                case COUNT: {
                    return COUNT;
                }
            }
            throw log.getAggregationTypeNotSupportedException(aggregationType.name());
        }
    }
}

