/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.directory;

import java.util.Arrays;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.impl.DirectoryBuilderImpl;
import org.infinispan.lucene.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class DirectoryBuilder {
    private static final Log log = (Log)LogFactory.getLog(DirectoryBuilder.class, Log.class);

    private DirectoryBuilder() {
    }

    public static BuildContext newDirectoryInstance(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName) {
        DirectoryBuilder.validateIndexCaches(indexName, metadataCache, chunksCache, distLocksCache);
        return new DirectoryBuilderImpl(metadataCache, chunksCache, distLocksCache, indexName);
    }

    private static void validateIndexCaches(String indexName, Cache<?, ?> ... caches) {
        Arrays.stream(caches).filter(Objects::nonNull).forEach(cache -> {
            ClusteringConfiguration clusteringConfiguration = cache.getCacheConfiguration().clustering();
            CacheMode cacheMode = clusteringConfiguration.cacheMode();
            if (cacheMode.isClustered() && !cacheMode.isSynchronous()) {
                throw log.cannotStoreIndexOnAsyncCaches(indexName, cache.getName(), cacheMode);
            }
        });
    }
}

