/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.impl.FileListCacheValueDelta;
import org.infinispan.lucene.impl.Operation;

@ThreadSafe
public final class FileListCacheValue
implements DeltaAware {
    private final Set<String> filenames = new HashSet<String>();
    private FileListCacheValueDelta fileListValueDelta = new FileListCacheValueDelta();
    private final Lock writeLock;
    private final Lock readLock;

    public FileListCacheValue() {
        ReentrantReadWriteLock namesLock = new ReentrantReadWriteLock();
        this.writeLock = namesLock.writeLock();
        this.readLock = namesLock.readLock();
    }

    public FileListCacheValue(String[] listAll) {
        this();
        Collections.addAll(this.filenames, listAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(List<Operation> operations) {
        this.writeLock.lock();
        try {
            for (Operation operation : operations) {
                operation.apply(this.filenames);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String fileName) {
        this.writeLock.lock();
        try {
            boolean removed = this.filenames.remove(fileName);
            if (removed) {
                this.fileListValueDelta.removeOperation(fileName);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String fileName) {
        this.writeLock.lock();
        try {
            boolean added = this.filenames.add(fileName);
            if (added) {
                this.fileListValueDelta.addOperation(fileName);
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAndRemove(String toAdd, String toRemove) {
        this.writeLock.lock();
        try {
            boolean doneAdd = this.filenames.add(toAdd);
            boolean doneRemove = this.filenames.remove(toRemove);
            if (doneAdd) {
                this.fileListValueDelta.addOperation(toAdd);
            }
            if (doneRemove) {
                this.fileListValueDelta.removeOperation(toRemove);
            }
            boolean bl = doneAdd || doneRemove;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String[] toArray() {
        this.readLock.lock();
        try {
            String[] stringArray = this.filenames.toArray(new String[this.filenames.size()]);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(String fileName) {
        this.readLock.lock();
        try {
            boolean bl = this.filenames.contains(fileName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.filenames.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        HashSet<String> copyFromOther;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileListCacheValue.class != obj.getClass()) {
            return false;
        }
        FileListCacheValue other = (FileListCacheValue)obj;
        other.readLock.lock();
        try {
            copyFromOther = new HashSet<String>(other.filenames);
        }
        finally {
            other.readLock.unlock();
        }
        this.readLock.lock();
        try {
            boolean bl = this.filenames.equals(copyFromOther);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = "FileListCacheValue [filenames=" + this.filenames + "]";
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public FileListCacheValueDelta delta() {
        this.readLock.lock();
        try {
            FileListCacheValueDelta toReturn = this.fileListValueDelta;
            this.fileListValueDelta = new FileListCacheValueDelta();
            FileListCacheValueDelta fileListCacheValueDelta = toReturn;
            return fileListCacheValueDelta;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void commit() {
        this.fileListValueDelta.discardOps();
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileListCacheValue> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeObject(ObjectOutput output, FileListCacheValue key) throws IOException {
            key.readLock.lock();
            try {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.filenames.size());
                for (String name : key.filenames) {
                    output.writeUTF(name);
                }
            }
            finally {
                key.readLock.unlock();
            }
        }

        public FileListCacheValue readObject(ObjectInput input) throws IOException {
            int size = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            String[] names = new String[size];
            for (int i = 0; i < size; ++i) {
                names[i] = input.readUTF();
            }
            return new FileListCacheValue(names);
        }

        public Integer getId() {
            return ExternalizerIds.FILE_LIST_CACHE_VALUE;
        }

        public Set<Class<? extends FileListCacheValue>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileListCacheValue.class});
        }
    }
}

