/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzer;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ScopedRemoteAnalyzer
extends RemoteAnalyzer
implements ScopedAnalyzer {
    private static final Log log = LoggerFactory.make();
    private RemoteAnalyzer globalAnalyzer;
    private final Map<String, RemoteAnalyzer> scopedAnalyzers;

    public ScopedRemoteAnalyzer(AnalyzerReference globalAnalyzerReference) {
        this(ScopedRemoteAnalyzer.getRemoteAnalyzer(globalAnalyzerReference), new HashMap<String, RemoteAnalyzer>());
    }

    private ScopedRemoteAnalyzer(RemoteAnalyzer globalAnalyzer, Map<String, RemoteAnalyzer> analyzers) {
        super(globalAnalyzer.name);
        this.globalAnalyzer = globalAnalyzer;
        this.scopedAnalyzers = analyzers;
    }

    @Override
    public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
        RemoteAnalyzer remoteAnalyzer = ScopedRemoteAnalyzer.getRemoteAnalyzer(globalAnalyzerReference);
        this.name = remoteAnalyzer.name;
        this.globalAnalyzer = remoteAnalyzer;
    }

    @Override
    public void addScopedAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
        this.scopedAnalyzers.put(scope, ScopedRemoteAnalyzer.getRemoteAnalyzer(analyzerReference));
    }

    @Override
    public void addScopedPassThroughAnalyzerReference(String scope) {
        this.scopedAnalyzers.put(scope, RemoteAnalyzerReference.PASS_THROUGH.getAnalyzer());
    }

    @Override
    public String getName(String fieldName) {
        RemoteAnalyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            return this.globalAnalyzer.getName(fieldName);
        }
        return analyzer.getName(fieldName);
    }

    @Override
    public ScopedAnalyzer clone() {
        return new ScopedRemoteAnalyzer(this.globalAnalyzer, this.scopedAnalyzers);
    }

    private static RemoteAnalyzer getRemoteAnalyzer(AnalyzerReference analyzerReference) {
        if (!(analyzerReference instanceof RemoteAnalyzerReference)) {
            throw log.analyzerReferenceIsNotRemote(analyzerReference);
        }
        return ((RemoteAnalyzerReference)analyzerReference).getAnalyzer();
    }
}

