/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.exception.SearchException;

public final class LazyAnalyzerReference
implements AnalyzerReference {
    private final String name;
    private AnalyzerReference delegate;

    public LazyAnalyzerReference(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
    }

    public void setDelegate(AnalyzerReference reference) {
        this.delegate = reference;
    }

    @Override
    public <T extends AnalyzerReference> boolean is(Class<T> analyzerType) {
        this.validate();
        if (LazyAnalyzerReference.class.isAssignableFrom(analyzerType)) {
            return true;
        }
        return this.delegate.is(analyzerType);
    }

    @Override
    public <T extends AnalyzerReference> T unwrap(Class<T> analyzerType) {
        if (LazyAnalyzerReference.class.isAssignableFrom(analyzerType)) {
            return (T)this;
        }
        this.validate();
        return this.delegate.unwrap(analyzerType);
    }

    private void validate() {
        if (this.delegate == null) {
            throw new SearchException("Analyzer not initialized");
        }
    }
}

