/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import io.searchbox.action.BulkableAction;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.indices.Refresh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.elasticsearch.client.impl.BulkRequestFailedException;
import org.hibernate.search.backend.elasticsearch.client.impl.JestClient;
import org.hibernate.search.backend.elasticsearch.impl.BackendRequest;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexWorkVisitor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;

public class ElasticsearchBackendQueueProcessor
implements BackendQueueProcessor {
    private ElasticsearchIndexManager indexManager;
    private ExtendedSearchIntegrator searchIntegrator;
    private ElasticsearchIndexWorkVisitor visitor;
    private ErrorHandler errorHandler;
    private JestClient jestClient;

    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.indexManager = (ElasticsearchIndexManager)indexManager;
        this.errorHandler = context.getErrorHandler();
        this.searchIntegrator = context.getUninitializedSearchIntegrator();
        this.visitor = new ElasticsearchIndexWorkVisitor(this.indexManager.getActualIndexName(), this.searchIntegrator);
        this.jestClient = (JestClient)context.getServiceManager().requestService(JestClient.class);
    }

    public void close() {
        this.searchIntegrator.getServiceManager().releaseService(JestClient.class);
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList.size() == 1) {
            this.doApplySingleWork(workList.iterator().next());
        } else {
            this.doApplyListOfWork(workList);
        }
    }

    private void doApplyListOfWork(List<LuceneWork> workList) {
        BackendRequestGroup nextBulk = null;
        Iterator<BackendRequestGroup> iterator = this.createRequestGroups(workList).iterator();
        while (iterator.hasNext()) {
            BackendRequestGroup backendRequestGroup;
            nextBulk = backendRequestGroup = iterator.next();
            nextBulk.execute();
        }
        try {
            nextBulk.ensureRefreshed();
        }
        catch (BulkRequestFailedException brfe) {
            this.errorHandler.handleException("Refresh failed", (Throwable)((Object)brfe));
        }
    }

    private List<BackendRequestGroup> createRequestGroups(List<LuceneWork> workList) {
        ArrayList<BackendRequestGroup> groups = new ArrayList<BackendRequestGroup>();
        ArrayList currentBulk = new ArrayList();
        for (LuceneWork luceneWork : workList) {
            BackendRequest request = (BackendRequest)luceneWork.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, (Object)false);
            if (request.getAction() instanceof BulkableAction) {
                currentBulk.add(request);
                continue;
            }
            if (!currentBulk.isEmpty()) {
                groups.add(new BackendRequestBulk(currentBulk, false));
                currentBulk.clear();
            }
            groups.add(new SingleRequest(request));
        }
        if (!currentBulk.isEmpty()) {
            groups.add(new BackendRequestBulk(currentBulk, true));
        }
        return groups;
    }

    private void refreshIndex() {
        Refresh refresh = ((Refresh.Builder)new Refresh.Builder().addIndex(this.indexManager.getActualIndexName())).build();
        this.jestClient.executeRequest(refresh, new int[0]);
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.doApplySingleWork(singleOperation);
    }

    private void doApplySingleWork(LuceneWork work) {
        try {
            BackendRequest request = (BackendRequest)work.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, (Object)true);
            if (request == null) {
                return;
            }
            this.jestClient.executeRequest(request.getAction(), request.getIgnoredErrorStatuses());
            if (request.getAction() instanceof DeleteByQuery) {
                this.refreshIndex();
            }
        }
        catch (Exception e) {
            ErrorContextBuilder builder = new ErrorContextBuilder();
            builder.allWorkToBeDone(Collections.singleton(work));
            builder.addWorkThatFailed(work);
            builder.errorThatOccurred((Throwable)e);
            this.errorHandler.handle(builder.createErrorContext());
        }
    }

    public Lock getExclusiveWriteLock() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void indexMappingChanged() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void flushAndReleaseResources() {
    }

    private class SingleRequest
    implements BackendRequestGroup {
        private final BackendRequest<?> request;

        public SingleRequest(BackendRequest<?> request) {
            this.request = request;
        }

        @Override
        public void execute() {
            try {
                ElasticsearchBackendQueueProcessor.this.jestClient.executeRequest(this.request.getAction(), this.request.getIgnoredErrorStatuses());
            }
            catch (Exception e) {
                ErrorContextBuilder builder = new ErrorContextBuilder();
                builder.allWorkToBeDone(Collections.singletonList(this.request.getLuceneWork()));
                builder.addWorkThatFailed(this.request.getLuceneWork());
                builder.errorThatOccurred((Throwable)e);
                ElasticsearchBackendQueueProcessor.this.errorHandler.handle(builder.createErrorContext());
            }
        }

        @Override
        public void ensureRefreshed() {
            ElasticsearchBackendQueueProcessor.this.refreshIndex();
        }
    }

    private class BackendRequestBulk
    implements BackendRequestGroup {
        private final List<BackendRequest<?>> requests;
        private final boolean refresh;

        public BackendRequestBulk(List<BackendRequest<?>> requests, boolean refresh) {
            this.requests = requests;
            this.refresh = refresh;
        }

        @Override
        public void execute() {
            try {
                ElasticsearchBackendQueueProcessor.this.jestClient.executeBulkRequest(this.requests, this.refresh);
            }
            catch (BulkRequestFailedException brfe) {
                ErrorContextBuilder builder = new ErrorContextBuilder();
                ArrayList<LuceneWork> allWork = new ArrayList<LuceneWork>();
                for (BackendRequest<?> backendRequest : this.requests) {
                    allWork.add(backendRequest.getLuceneWork());
                    if (brfe.getErroneousItems().contains(backendRequest)) continue;
                    builder.workCompleted(backendRequest.getLuceneWork());
                }
                builder.allWorkToBeDone(allWork);
                for (BackendRequest<?> failedAction : brfe.getErroneousItems()) {
                    builder.addWorkThatFailed(failedAction.getLuceneWork());
                }
                builder.errorThatOccurred((Throwable)((Object)brfe));
                ElasticsearchBackendQueueProcessor.this.errorHandler.handle(builder.createErrorContext());
            }
            catch (Exception e) {
                ElasticsearchBackendQueueProcessor.this.errorHandler.handleException("Bulk request failed", (Throwable)e);
            }
        }

        @Override
        public void ensureRefreshed() {
            if (!this.refresh) {
                ElasticsearchBackendQueueProcessor.this.refreshIndex();
            }
        }
    }

    private static interface BackendRequestGroup {
        public void execute();

        public void ensureRefreshed();
    }
}

