/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.action.Action;
import io.searchbox.core.Delete;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.Index;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.elasticsearch.impl.BackendRequest;
import org.hibernate.search.backend.elasticsearch.impl.DocumentIdHelper;
import org.hibernate.search.backend.elasticsearch.impl.FieldHelper;
import org.hibernate.search.backend.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.backend.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchIndexWorkVisitor
implements IndexWorkVisitor<Boolean, BackendRequest<?>> {
    private static final Log LOG = LoggerFactory.make();
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern NAME_AND_INDEX = Pattern.compile("(.+?)(\\[([0-9])+\\])?");
    private static final String DELETE_ALL_QUERY = "{ \"query\" : { \"constant_score\" : { \"filter\" : { \"match_all\" : { } } } } }";
    private static final String DELETE_ALL_FOR_TENANT_QUERY = "{ \"query\" : { \"constant_score\" : { \"filter\" : { \"term\" : { \"__HSearch_TenantId\" : \"%s\" } } } } }";
    private final String indexName;
    private final ExtendedSearchIntegrator searchIntegrator;

    public ElasticsearchIndexWorkVisitor(String indexName, ExtendedSearchIntegrator searchIntegrator) {
        this.indexName = indexName;
        this.searchIntegrator = searchIntegrator;
    }

    public BackendRequest<?> visitAddWork(AddLuceneWork work, Boolean refresh) {
        Action<?> index = this.indexDocument(DocumentIdHelper.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass(), refresh);
        return new BackendRequest(index, (LuceneWork)work, new int[0]);
    }

    public BackendRequest<?> visitDeleteWork(DeleteLuceneWork work, Boolean refresh) {
        Delete delete = ((Delete.Builder)((Delete.Builder)((Delete.Builder)new Delete.Builder(DocumentIdHelper.getDocumentId((LuceneWork)work)).index(this.indexName)).type(work.getEntityClass().getName())).refresh(refresh.booleanValue())).build();
        return new BackendRequest(delete, (LuceneWork)work, new int[]{404});
    }

    public BackendRequest<?> visitOptimizeWork(OptimizeLuceneWork work, Boolean refresh) {
        LOG.warn((Object)"Optimize work is not yet supported for Elasticsearch backend, ignoring it");
        return null;
    }

    public BackendRequest<?> visitPurgeAllWork(PurgeAllLuceneWork work, Boolean refresh) {
        String query = work.getTenantId() != null ? String.format(Locale.ENGLISH, DELETE_ALL_FOR_TENANT_QUERY, work.getTenantId()) : DELETE_ALL_QUERY;
        DeleteByQuery.Builder builder = (DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(query).refresh(refresh.booleanValue())).addIndex(this.indexName);
        Set typesToDelete = this.searchIntegrator.getIndexedTypesPolymorphic(new Class[]{work.getEntityClass()});
        for (Class typeToDelete : typesToDelete) {
            builder.addType(typeToDelete.getName());
        }
        return new BackendRequest(builder.build(), (LuceneWork)work, new int[0]);
    }

    public BackendRequest<?> visitUpdateWork(UpdateLuceneWork work, Boolean refresh) {
        Action<?> index = this.indexDocument(DocumentIdHelper.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass(), refresh);
        return new BackendRequest(index, (LuceneWork)work, new int[0]);
    }

    public BackendRequest<?> visitFlushWork(FlushLuceneWork work, Boolean refresh) {
        return null;
    }

    public BackendRequest<?> visitDeleteByQueryWork(DeleteByQueryLuceneWork work, Boolean refresh) {
        JsonObject convertedQuery = ToElasticsearch.fromDeletionQuery(this.searchIntegrator.getIndexBinding(work.getEntityClass()).getDocumentBuilder(), work.getDeletionQuery());
        String type = work.getEntityClass().getName();
        JsonObject query = work.getTenantId() != null ? JsonBuilder.object().add("query", JsonBuilder.object().add("filtered", JsonBuilder.object().add("filter", JsonBuilder.object().add("term", JsonBuilder.object().addProperty("__HSearch_TenantId", work.getTenantId()))).add("query", (JsonElement)convertedQuery))).build() : JsonBuilder.object().add("query", (JsonElement)convertedQuery).build();
        DeleteByQuery deleteByQuery = ((DeleteByQuery.Builder)((DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(query.toString()).addIndex(this.indexName)).addType(type)).refresh(refresh.booleanValue())).build();
        return new BackendRequest(deleteByQuery, (LuceneWork)work, new int[0]);
    }

    private Action<?> indexDocument(String id, Document document, Class<?> entityType, boolean refresh) {
        JsonObject source = this.convertToJson(document, entityType);
        String type = entityType.getName();
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)source).index(this.indexName)).type(type)).id(id)).refresh(refresh)).build();
        return index;
    }

    private JsonObject convertToJson(Document document, Class<?> entityType) {
        EntityIndexBinding indexBinding = this.searchIntegrator.getIndexBinding(entityType);
        JsonObject source = new JsonObject();
        String parentPath = null;
        for (IndexableField field : document.getFields()) {
            if ("$nesting".equals(field.name())) {
                parentPath = field.stringValue();
                continue;
            }
            if (!(field.name().equals("_hibernate_class") || field.name().equals(indexBinding.getDocumentBuilder().getIdKeywordName()) || "$facets".equals(field.name()) || this.isDocValueField(field))) {
                Object value;
                JsonObject parent = this.getOrCreateDocumentTree(source, parentPath);
                String jsonPropertyName = FieldHelper.getEmbeddedFieldPropertyName(field.name());
                DocumentFieldMetadata documentFieldMetadata = indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(field.name());
                if (documentFieldMetadata == null) {
                    if (SpatialHelper.isSpatialField((String)jsonPropertyName)) {
                        if (this.isNumeric(field) && (SpatialHelper.isSpatialFieldLatitude((String)jsonPropertyName) || SpatialHelper.isSpatialFieldLongitude((String)jsonPropertyName))) {
                            JsonObject spatialParent;
                            value = field.numericValue();
                            String spatialJsonPropertyName = SpatialHelper.getSpatialFieldRootName((String)jsonPropertyName);
                            if (parent.get(spatialJsonPropertyName) != null) {
                                spatialParent = parent.get(spatialJsonPropertyName).getAsJsonObject();
                            } else {
                                spatialParent = new JsonObject();
                                parent.add(spatialJsonPropertyName, (JsonElement)spatialParent);
                            }
                            if (SpatialHelper.isSpatialFieldLatitude((String)jsonPropertyName)) {
                                this.addPropertyOfPotentiallyMultipleCardinality(spatialParent, "lat", value != null ? new JsonPrimitive((Number)value) : null);
                                continue;
                            }
                            if (!SpatialHelper.isSpatialFieldLongitude((String)jsonPropertyName)) continue;
                            this.addPropertyOfPotentiallyMultipleCardinality(spatialParent, "lon", value != null ? new JsonPrimitive((Number)value) : null);
                            continue;
                        }
                        value = field.stringValue();
                        this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive((String)value) : null);
                        continue;
                    }
                    String[] fieldNameParts = FieldHelper.getFieldNameParts(field.name());
                    EmbeddedTypeMetadata embeddedType = this.getEmbeddedTypeMetadata(indexBinding.getDocumentBuilder().getTypeMetadata(), fieldNameParts);
                    if (embeddedType != null) continue;
                    String stringValue = field.stringValue();
                    if (stringValue != null) {
                        this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, new JsonPrimitive(stringValue));
                        continue;
                    }
                    this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, field.numericValue() != null ? new JsonPrimitive(field.numericValue()) : null);
                    continue;
                }
                if (FieldHelper.isBoolean(indexBinding, field.name())) {
                    FieldBridge fieldBridge = documentFieldMetadata.getFieldBridge();
                    Boolean value2 = (Boolean)((TwoWayFieldBridge)fieldBridge).get(field.name(), document);
                    this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value2 != null ? new JsonPrimitive(value2) : null);
                    continue;
                }
                if (FieldHelper.isNumeric(documentFieldMetadata) || this.isNumeric(field)) {
                    value = field.numericValue();
                    if (value != null && value.toString().equals(documentFieldMetadata.indexNullAs())) {
                        value = null;
                    }
                    this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive((Number)value) : null);
                    continue;
                }
                value = field.stringValue();
                if (value != null && ((String)value).equals(documentFieldMetadata.indexNullAs())) {
                    value = null;
                }
                this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive((String)value) : null);
                continue;
            }
            if ("$facets".equals(field.name()) && field instanceof SortedSetDocValuesField) {
                String[] facetParts = FacetsConfig.stringToPath((String)field.binaryValue().utf8ToString());
                if (facetParts == null || facetParts.length != 2) continue;
                String fieldName = facetParts[0];
                String value = facetParts[1];
                if (indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(fieldName) != null) continue;
                JsonObject parent = this.getOrCreateDocumentTree(source, fieldName);
                String jsonPropertyName = FieldHelper.getEmbeddedFieldPropertyName(fieldName);
                this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive(value) : null);
                continue;
            }
            if (!this.isDocValueField(field) || !(field instanceof NumericDocValuesField) || indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(field.name()) != null) continue;
            Number value = field instanceof DoubleDocValuesField ? (Number)Double.longBitsToDouble(field.numericValue().longValue()) : (Number)field.numericValue();
            JsonObject parent = this.getOrCreateDocumentTree(source, parentPath);
            String jsonPropertyName = FieldHelper.getEmbeddedFieldPropertyName(field.name());
            this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive(value) : null);
        }
        return source;
    }

    private void addPropertyOfPotentiallyMultipleCardinality(JsonObject parent, String propertyName, JsonPrimitive value) {
        JsonElement currentValue = parent.get(propertyName);
        if (currentValue == null) {
            JsonBuilder.object(parent).add(propertyName, (JsonElement)value);
        } else if (!currentValue.isJsonArray()) {
            parent.remove(propertyName);
            parent.add(propertyName, (JsonElement)JsonBuilder.array().add(currentValue).add((JsonElement)value).build());
        } else {
            currentValue.getAsJsonArray().add((JsonElement)value);
        }
    }

    private boolean isNumeric(IndexableField field) {
        return field instanceof IntField || field instanceof LongField || field instanceof FloatField || field instanceof DoubleField;
    }

    private EmbeddedTypeMetadata getEmbeddedTypeMetadata(TypeMetadata type, String[] fieldNameParts) {
        TypeMetadata parent = type;
        for (String namePart : fieldNameParts) {
            EmbeddedTypeMetadata embeddedType = this.getDirectEmbeddedTypeMetadata(parent, namePart);
            if (embeddedType == null) {
                return null;
            }
            parent = embeddedType;
        }
        return (EmbeddedTypeMetadata)parent;
    }

    private EmbeddedTypeMetadata getDirectEmbeddedTypeMetadata(TypeMetadata type, String fieldName) {
        for (EmbeddedTypeMetadata embeddedType : type.getEmbeddedTypeMetadata()) {
            if (!embeddedType.getEmbeddedFieldName().equals(fieldName)) continue;
            return embeddedType;
        }
        return null;
    }

    private JsonObject getOrCreateDocumentTree(JsonObject source, String path) {
        if (path == null) {
            return source;
        }
        String[] parts = DOT.split(path);
        JsonObject parent = source;
        for (int i = 0; i < parts.length; ++i) {
            Matcher nameAndIndex = NAME_AND_INDEX.matcher(parts[i]);
            nameAndIndex.matches();
            String name = nameAndIndex.group(1);
            String idx = nameAndIndex.group(3);
            Integer index = null;
            if (idx != null) {
                JsonObject newParent;
                index = Integer.valueOf(idx);
                JsonArray array = parent.getAsJsonArray(name);
                if (array == null) {
                    array = new JsonArray();
                    parent.add(name, (JsonElement)array);
                }
                JsonObject jsonObject = newParent = index < array.size() ? array.get(index.intValue()).getAsJsonObject() : null;
                if (newParent == null) {
                    newParent = new JsonObject();
                    if (index >= array.size()) {
                        for (int j = array.size(); j <= index; ++j) {
                            array.add((JsonElement)JsonNull.INSTANCE);
                        }
                    }
                    array.set(index.intValue(), (JsonElement)newParent);
                }
                parent = newParent;
                continue;
            }
            JsonObject newParent = parent.getAsJsonObject(name);
            if (newParent == null) {
                newParent = new JsonObject();
                parent.add(name, (JsonElement)newParent);
            }
            parent = newParent;
        }
        return parent;
    }

    private boolean isDocValueField(IndexableField field) {
        return field.fieldType().docValuesType() != DocValuesType.NONE;
    }
}

