/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.document.Document;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.remoting.rpc.RpcManager;

public class AffinityShardIdentifierProvider
implements ShardIdentifierProvider {
    private RpcManager rpcManager;
    private DistributionManager distributionManager;
    private KeyTransformationHandler keyTransformationHandler;
    private ComponentRegistry componentRegistry;
    private Set<String> identifiers;

    public void initialize(Properties properties, BuildContext buildContext) {
        String cacheName;
        ServiceManager serviceManager = buildContext.getServiceManager();
        ComponentRegistryService componentRegistryService = (ComponentRegistryService)serviceManager.requestService(ComponentRegistryService.class);
        this.componentRegistry = componentRegistryService.getComponentRegistry();
        CacheManagerService cacheManagerService = (CacheManagerService)serviceManager.requestService(CacheManagerService.class);
        EmbeddedCacheManager embeddedCacheManager = cacheManagerService.getEmbeddedCacheManager();
        ClusteringConfiguration clusteringConfiguration = embeddedCacheManager.getCacheConfiguration(cacheName = this.componentRegistry.getCacheName()).clustering();
        int numSegments = clusteringConfiguration.cacheMode().isClustered() ? clusteringConfiguration.hash().numSegments() : 1;
        this.identifiers = IntStream.rangeClosed(0, numSegments - 1).boxed().map(String::valueOf).collect(Collectors.toSet());
    }

    private int getSegment(Object key) {
        DistributionManager distributionManager = this.getDistributionManager();
        if (distributionManager == null) {
            return 0;
        }
        return distributionManager.getReadConsistentHash().getSegment(key);
    }

    private Set<String> getShards() {
        return this.identifiers;
    }

    public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
        Object key = this.getKeyTransformationHandler().stringToKey(idAsString, null);
        int segment = this.getSegment(key);
        return String.valueOf(segment);
    }

    public Set<String> getShardIdentifiersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.getShards();
    }

    public Set<String> getShardIdentifiersForDeletion(Class<?> entity, Serializable id, String idInString) {
        if (this.getDistributionManager() == null) {
            return Collections.singleton("0");
        }
        Set segmentsForOwner = this.getDistributionManager().getConsistentHash().getPrimarySegmentsForOwner(this.getRpcManager().getAddress());
        return segmentsForOwner.stream().map(String::valueOf).collect(Collectors.toSet());
    }

    public Set<String> getAllShardIdentifiers() {
        return this.getShards();
    }

    private KeyTransformationHandler getKeyTransformationHandler() {
        if (this.keyTransformationHandler == null) {
            this.keyTransformationHandler = ((QueryInterceptor)((Object)this.componentRegistry.getComponent(QueryInterceptor.class))).getKeyTransformationHandler();
        }
        return this.keyTransformationHandler;
    }

    private RpcManager getRpcManager() {
        if (this.rpcManager == null) {
            this.rpcManager = (RpcManager)this.componentRegistry.getComponent(RpcManager.class);
        }
        return this.rpcManager;
    }

    private DistributionManager getDistributionManager() {
        if (this.distributionManager == null) {
            this.distributionManager = (DistributionManager)this.componentRegistry.getComponent(DistributionManager.class);
        }
        return this.distributionManager;
    }
}

