/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Consumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyKeyCommand<K, V>
extends AbstractWriteKeyCommand<K> {
    public static final byte COMMAND_ID = 54;
    private Consumer<EntryView.WriteEntryView<V>> f;

    public WriteOnlyKeyCommand(K key, Consumer<EntryView.WriteEntryView<V>> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params) {
        super(key, valueMatcher, id, params);
        this.f = f;
    }

    public WriteOnlyKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 54;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeObject(this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Consumer)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = (CommandInvocationId)input.readObject();
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyKeyCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        this.f.accept(EntryViews.writeOnly(e));
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }
}

