/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.L1ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfigurationBuilder;
import org.infinispan.configuration.cache.SyncConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteringConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements ClusteringConfigurationChildBuilder,
Builder<ClusteringConfiguration> {
    private static final Log log = LogFactory.getLog(ClusteringConfigurationBuilder.class, Log.class);
    private final HashConfigurationBuilder hashConfigurationBuilder;
    private final L1ConfigurationBuilder l1ConfigurationBuilder;
    private final StateTransferConfigurationBuilder stateTransferConfigurationBuilder;
    private final SyncConfigurationBuilder syncConfigurationBuilder;
    private final PartitionHandlingConfigurationBuilder partitionHandlingConfigurationBuilder;
    private final AttributeSet attributes = ClusteringConfiguration.attributeDefinitionSet();

    ClusteringConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.hashConfigurationBuilder = new HashConfigurationBuilder(this);
        this.l1ConfigurationBuilder = new L1ConfigurationBuilder(this);
        this.stateTransferConfigurationBuilder = new StateTransferConfigurationBuilder(this);
        this.syncConfigurationBuilder = new SyncConfigurationBuilder(this);
        this.partitionHandlingConfigurationBuilder = new PartitionHandlingConfigurationBuilder(this);
    }

    public ClusteringConfigurationBuilder cacheMode(CacheMode cacheMode) {
        this.attributes.attribute(ClusteringConfiguration.CACHE_MODE).set((Object)cacheMode);
        return this;
    }

    public CacheMode cacheMode() {
        return (CacheMode)((Object)this.attributes.attribute(ClusteringConfiguration.CACHE_MODE).get());
    }

    public ClusteringConfigurationBuilder remoteTimeout(long l) {
        this.syncConfigurationBuilder.replTimeout(l);
        return this;
    }

    public ClusteringConfigurationBuilder remoteTimeout(long l, TimeUnit unit) {
        return this.remoteTimeout(unit.toMillis(l));
    }

    @Override
    public HashConfigurationBuilder hash() {
        return this.hashConfigurationBuilder;
    }

    @Override
    public L1ConfigurationBuilder l1() {
        return this.l1ConfigurationBuilder;
    }

    @Override
    public StateTransferConfigurationBuilder stateTransfer() {
        return this.stateTransferConfigurationBuilder;
    }

    @Override
    public SyncConfigurationBuilder sync() {
        if (!this.cacheMode().isSynchronous()) {
            throw log.syncPropertiesConfigOnAsyncCache();
        }
        return this.syncConfigurationBuilder;
    }

    @Override
    public PartitionHandlingConfigurationBuilder partitionHandling() {
        return this.partitionHandlingConfigurationBuilder;
    }

    public void validate() {
        for (Builder builder : Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.syncConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            builder.validate();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.cacheMode().isClustered() && globalConfig.transport().transport() == null) {
            throw log.missingTransportConfiguration();
        }
        for (ConfigurationChildBuilder configurationChildBuilder : Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.syncConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            configurationChildBuilder.validate(globalConfig);
        }
    }

    public ClusteringConfiguration create() {
        return new ClusteringConfiguration(this.attributes.protect(), this.hashConfigurationBuilder.create(), this.l1ConfigurationBuilder.create(), this.stateTransferConfigurationBuilder.create(), this.syncConfigurationBuilder.create(), this.partitionHandlingConfigurationBuilder.create());
    }

    public ClusteringConfigurationBuilder read(ClusteringConfiguration template) {
        this.attributes.read(template.attributes());
        this.hashConfigurationBuilder.read(template.hash());
        this.l1ConfigurationBuilder.read(template.l1());
        this.stateTransferConfigurationBuilder.read(template.stateTransfer());
        this.syncConfigurationBuilder.read(template.sync());
        this.partitionHandlingConfigurationBuilder.read(template.partitionHandling());
        return this;
    }

    public String toString() {
        return "ClusteringConfigurationBuilder [hashConfigurationBuilder=" + this.hashConfigurationBuilder + ", l1ConfigurationBuilder=" + this.l1ConfigurationBuilder + ", stateTransferConfigurationBuilder=" + this.stateTransferConfigurationBuilder + ", syncConfigurationBuilder=" + this.syncConfigurationBuilder + ", partitionHandlingConfigurationBuilder=" + this.partitionHandlingConfigurationBuilder + ", attributes=" + this.attributes + "]";
    }
}

