/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Version;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.uberjar.ManifestUberJarDuplicatedJarsWarner;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.persistence.factory.CacheStoreFactoryRegistry;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.registry.impl.InternalCacheRegistryImpl;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.xsite.GlobalXSiteAdminOperations;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@ThreadSafe
public class GlobalComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(GlobalComponentRegistry.class);
    private static final AtomicBoolean versionLogged = new AtomicBoolean(false);
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;
    private final GlobalConfiguration globalConfiguration;
    private final Set<String> createdCaches;
    private final ModuleProperties moduleProperties = new ModuleProperties();
    private final ComponentMetadataRepo componentMetadataRepo;
    final Collection<ModuleLifecycle> moduleLifecycles;
    final ConcurrentMap<String, ComponentRegistry> namedComponents = new ConcurrentHashMap<String, ComponentRegistry>(4);
    protected final WeakReference<ClassLoader> defaultClassLoader;

    public GlobalComponentRegistry(GlobalConfiguration configuration, EmbeddedCacheManager cacheManager, Set<String> createdCaches) {
        ClassLoader configuredClassLoader = configuration.classLoader();
        this.moduleLifecycles = ModuleProperties.resolveModuleLifecycles(configuredClassLoader);
        this.componentMetadataRepo = new ComponentMetadataRepo();
        this.componentMetadataRepo.initialize(ModuleProperties.getModuleMetadataFiles(configuredClassLoader), configuredClassLoader);
        this.defaultClassLoader = new WeakReference<ClassLoader>(this.registerDefaultClassLoader(configuredClassLoader));
        try {
            this.globalConfiguration = configuration;
            this.registerComponent((Object)this, GlobalComponentRegistry.class);
            this.registerComponent((Object)configuration, GlobalConfiguration.class);
            this.registerComponent((Object)cacheManager, EmbeddedCacheManager.class);
            this.registerComponent((Object)new CacheManagerJmxRegistration(), CacheManagerJmxRegistration.class);
            this.registerComponent((Object)new CacheManagerNotifierImpl(), CacheManagerNotifier.class);
            this.registerComponent((Object)new InternalCacheRegistryImpl(), InternalCacheRegistry.class);
            this.registerComponent((Object)new CacheStoreFactoryRegistry(), CacheStoreFactoryRegistry.class);
            this.registerComponent((Object)new GlobalXSiteAdminOperations(), GlobalXSiteAdminOperations.class);
            this.moduleProperties.loadModuleCommandHandlers(configuredClassLoader);
            Map<Byte, ModuleCommandFactory> factories = this.moduleProperties.moduleCommandFactories();
            if (factories != null && !factories.isEmpty()) {
                this.registerNonVolatileComponent(factories, "org.infinispan.modules.command.factories");
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.factories");
            }
            this.createdCaches = createdCaches;
            this.getOrCreateComponent(EventLogManager.class);
            this.getOrCreateComponent(Transport.class);
            this.getOrCreateComponent(LocalTopologyManager.class);
            this.getOrCreateComponent(ClusterTopologyManager.class);
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a GlobalComponentRegistry!", (Throwable)e);
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return (ClassLoader)this.defaultClassLoader.get();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public ComponentMetadataRepo getComponentMetadataRepo() {
        return this.componentMetadataRepo;
    }

    @Override
    protected synchronized void removeShutdownHook() {
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public TimeService getTimeService() {
        return this.getOrCreateComponent(TimeService.class);
    }

    @Override
    protected synchronized void addShutdownHook() {
        boolean registerShutdownHook;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(null);
        ShutdownHookBehavior shutdownHookBehavior = this.globalConfiguration.shutdown().hookBehavior();
        boolean bl = registerShutdownHook = shutdownHookBehavior == ShutdownHookBehavior.DEFAULT && al.isEmpty() || shutdownHookBehavior == ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            log.tracef("Registering a shutdown hook.  Configured behavior = %s", (Object)shutdownHookBehavior);
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    try {
                        GlobalComponentRegistry.this.invokedFromShutdownHook = true;
                        GlobalComponentRegistry.this.stop();
                    }
                    finally {
                        GlobalComponentRegistry.this.invokedFromShutdownHook = false;
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            log.tracef("Not registering a shutdown hook.  Configured behavior = %s", (Object)shutdownHookBehavior);
        }
    }

    public final ComponentRegistry getNamedComponentRegistry(String name) {
        return (ComponentRegistry)this.namedComponents.get(name);
    }

    public final synchronized void registerNamedComponentRegistry(ComponentRegistry componentRegistry, String name) {
        this.namedComponents.put(name, componentRegistry);
    }

    public final synchronized void unregisterNamedComponentRegistry(String name) {
        this.namedComponents.remove(name);
    }

    public final synchronized void rewireNamedRegistries() {
        for (ComponentRegistry cr : this.namedComponents.values()) {
            cr.rewire();
        }
    }

    public Map<Byte, ModuleCommandInitializer> getModuleCommandInitializers() {
        return Collections.unmodifiableMap(this.moduleProperties.moduleCommandInitializers());
    }

    @Override
    public synchronized void start() {
        try {
            boolean needToNotify;
            if (!this.state.startAllowed()) {
                return;
            }
            boolean bl = needToNotify = this.state != ComponentStatus.RUNNING && this.state != ComponentStatus.INITIALIZING;
            if (needToNotify) {
                for (ModuleLifecycle l : this.moduleLifecycles) {
                    l.cacheManagerStarting(this, this.globalConfiguration);
                }
            }
            super.start();
            if (versionLogged.compareAndSet(false, true)) {
                log.version(Version.printVersion());
            }
            if (needToNotify && this.state == ComponentStatus.RUNNING) {
                for (ModuleLifecycle l : this.moduleLifecycles) {
                    l.cacheManagerStarted(this);
                }
            }
            this.warnAboutUberJarDuplicates();
        }
        catch (RuntimeException rte) {
            EmbeddedCacheManagerStartupException exception = new EmbeddedCacheManagerStartupException(rte);
            this.state = ComponentStatus.FAILED;
            try {
                super.stop();
            }
            catch (Exception e) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
    }

    private final void warnAboutUberJarDuplicates() {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner();
        scanner.isClasspathCorrectAsync().thenAcceptAsync(isClasspathCorrect -> {
            if (!isClasspathCorrect.booleanValue()) {
                log.warnAboutUberJarDuplicates();
            }
        });
    }

    @Override
    public synchronized void stop() {
        boolean needToNotify;
        boolean bl = needToNotify = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        if (needToNotify) {
            for (ModuleLifecycle l : this.moduleLifecycles) {
                l.cacheManagerStopping(this);
            }
        }
        super.stop();
        if (this.state == ComponentStatus.TERMINATED && needToNotify) {
            for (ModuleLifecycle l : this.moduleLifecycles) {
                l.cacheManagerStopped(this);
            }
        }
    }

    public void notifyCacheStarted(String cacheName) {
        ComponentRegistry cr = this.getNamedComponentRegistry(cacheName);
        for (ModuleLifecycle l : this.moduleLifecycles) {
            l.cacheStarted(cr, cacheName);
        }
    }

    public final GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public synchronized boolean removeCache(String cacheName) {
        return this.createdCaches.remove(cacheName);
    }

    public ModuleProperties getModuleProperties() {
        return this.moduleProperties;
    }
}

