/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopology {
    private static Log log = LogFactory.getLog(CacheTopology.class);
    private static final boolean trace = log.isTraceEnabled();
    private final int topologyId;
    private final int rebalanceId;
    private final ConsistentHash currentCH;
    private final ConsistentHash pendingCH;
    private final transient ConsistentHash unionCH;
    private List<Address> actualMembers;
    private List<PersistentUUID> persistentUUIDs;

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        this(topologyId, rebalanceId, currentCH, pendingCH, null, actualMembers, persistentUUIDs);
    }

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, ConsistentHash unionCH, List<Address> actualMembers, List<PersistentUUID> persistentUUIDs) {
        if (pendingCH != null && !pendingCH.getMembers().containsAll(currentCH.getMembers())) {
            throw new IllegalArgumentException("A cache topology's pending consistent hash must contain all the current consistent hash's members");
        }
        this.topologyId = topologyId;
        this.rebalanceId = rebalanceId;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.unionCH = unionCH;
        this.actualMembers = actualMembers;
        this.persistentUUIDs = persistentUUIDs;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public ConsistentHash getUnionCH() {
        return this.unionCH;
    }

    public int getRebalanceId() {
        return this.rebalanceId;
    }

    public List<Address> getMembers() {
        if (this.pendingCH != null) {
            return this.pendingCH.getMembers();
        }
        if (this.currentCH != null) {
            return this.currentCH.getMembers();
        }
        return Collections.emptyList();
    }

    public List<Address> getActualMembers() {
        return this.actualMembers;
    }

    public List<PersistentUUID> getMembersPersistentUUIDs() {
        return this.persistentUUIDs;
    }

    public ConsistentHash getReadConsistentHash() {
        return this.currentCH;
    }

    public ConsistentHash getWriteConsistentHash() {
        if (this.pendingCH != null) {
            if (this.unionCH == null) {
                throw new IllegalStateException("Need a union CH when a pending CH is set");
            }
            return this.unionCH;
        }
        return this.currentCH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheTopology that = (CacheTopology)o;
        if (this.topologyId != that.topologyId) {
            return false;
        }
        if (this.rebalanceId != that.rebalanceId) {
            return false;
        }
        if (this.currentCH != null ? !this.currentCH.equals(that.currentCH) : that.currentCH != null) {
            return false;
        }
        if (this.pendingCH != null ? !this.pendingCH.equals(that.pendingCH) : that.pendingCH != null) {
            return false;
        }
        if (this.unionCH != null ? !this.unionCH.equals(that.unionCH) : that.unionCH != null) {
            return false;
        }
        return !(this.actualMembers != null ? !this.actualMembers.equals(that.actualMembers) : that.actualMembers != null);
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + this.rebalanceId;
        result = 31 * result + (this.currentCH != null ? this.currentCH.hashCode() : 0);
        result = 31 * result + (this.pendingCH != null ? this.pendingCH.hashCode() : 0);
        result = 31 * result + (this.unionCH != null ? this.unionCH.hashCode() : 0);
        result = 31 * result + (this.actualMembers != null ? this.actualMembers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CacheTopology{id=" + this.topologyId + ", rebalanceId=" + this.rebalanceId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", unionCH=" + this.unionCH + ", actualMembers=" + this.actualMembers + ", persistentUUIDs=" + this.persistentUUIDs + '}';
    }

    public final void logRoutingTableInformation() {
        if (trace) {
            log.tracef("Current consistent hash's routing table: %s", this.currentCH.getRoutingTableAsString());
            if (this.pendingCH != null) {
                log.tracef("Pending consistent hash's routing table: %s", this.pendingCH.getRoutingTableAsString());
            }
            if (this.unionCH != null) {
                log.tracef("Union consistent hash's routing table: %s", this.unionCH.getRoutingTableAsString());
            }
        }
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<CacheTopology> {
        public void doWriteObject(ObjectOutput output, CacheTopology cacheTopology) throws IOException {
            output.writeInt(cacheTopology.topologyId);
            output.writeInt(cacheTopology.rebalanceId);
            output.writeObject(cacheTopology.currentCH);
            output.writeObject(cacheTopology.pendingCH);
            output.writeObject(cacheTopology.unionCH);
            output.writeObject(cacheTopology.actualMembers);
            output.writeObject(cacheTopology.persistentUUIDs);
        }

        public CacheTopology doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int topologyId = unmarshaller.readInt();
            int rebalanceId = unmarshaller.readInt();
            ConsistentHash currentCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash pendingCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash unionCH = (ConsistentHash)unmarshaller.readObject();
            List actualMembers = (List)unmarshaller.readObject();
            List persistentUUIDs = (List)unmarshaller.readObject();
            return new CacheTopology(topologyId, rebalanceId, currentCH, pendingCH, unionCH, actualMembers, persistentUUIDs);
        }

        public Integer getId() {
            return 75;
        }

        public Set<Class<? extends CacheTopology>> getTypeClasses() {
            return Collections.singleton(CacheTopology.class);
        }
    }
}

