/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.FilterQueryResolverDelegate;
import org.infinispan.objectfilter.impl.hql.FilterRendererDelegate;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.predicate.FilterPredicateFactory;
import org.infinispan.objectfilter.impl.hql.predicate.SingleEntityHavingQueryBuilderImpl;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;

public final class JPQLParser<TypeMetadata> {
    private static final QueryParser queryParser = new QueryParser();
    private final EntityNamesResolver entityNamesResolver;
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;

    public JPQLParser(EntityNamesResolver entityNamesResolver, ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.entityNamesResolver = entityNamesResolver;
        this.propertyHelper = propertyHelper;
    }

    public FilterParsingResult<TypeMetadata> parse(String jpaQuery) {
        final QueryResolverProcessor resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)new FilterQueryResolverDelegate(this.entityNamesResolver, this.propertyHelper));
        FilterPredicateFactory predicateFactory = new FilterPredicateFactory(this.entityNamesResolver, this.propertyHelper);
        SingleEntityQueryBuilder queryBuilder = SingleEntityQueryBuilder.getInstance((PredicateFactory)predicateFactory, this.propertyHelper);
        SingleEntityHavingQueryBuilderImpl havingQueryBuilder = new SingleEntityHavingQueryBuilderImpl(this.entityNamesResolver, this.propertyHelper);
        final FilterRendererDelegate<TypeMetadata> rendererDelegate = new FilterRendererDelegate<TypeMetadata>(jpaQuery, this.entityNamesResolver, this.propertyHelper, (SingleEntityQueryBuilder<BooleanExpr>)queryBuilder, havingQueryBuilder, JPQLParser.makeParamPlaceholderMap());
        final QueryRendererProcessor rendererProcessor = new QueryRendererProcessor(rendererDelegate);
        AstProcessingChain chain = new AstProcessingChain<FilterParsingResult<TypeMetadata>>(){

            public Iterator<AstProcessor> iterator() {
                return Arrays.asList(resolverProcessor, rendererProcessor).iterator();
            }

            public FilterParsingResult<TypeMetadata> getResult() {
                return rendererDelegate.getResult();
            }
        };
        return (FilterParsingResult)queryParser.parseQuery(jpaQuery, chain);
    }

    private static Map<String, Object> makeParamPlaceholderMap() {
        return new HashMap<String, Object>(5){

            @Override
            public Object get(Object key) {
                String keyAsString = (String)key;
                Object v = super.get(keyAsString);
                if (v == null) {
                    v = new ConstantValueExpr.ParamPlaceholder(keyAsString);
                    this.put(keyAsString, v);
                }
                return v;
            }
        };
    }
}

