/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.beans.IntrospectionException;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;

public final class ReflectionPropertyHelper
extends ObjectPropertyHelper<Class<?>> {
    public ReflectionPropertyHelper(EntityNamesResolver entityNamesResolver) {
        super(entityNamesResolver);
    }

    @Override
    public Class<?> getEntityMetadata(String targetTypeName) {
        return this.entityNamesResolver.getClassFromName(targetTypeName);
    }

    @Override
    public Class<?> getPrimitivePropertyType(String entityType, String[] propertyPath) {
        Class type = this.entityNamesResolver.getClassFromName(entityType);
        if (type == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(type, propertyPath).getPropertyType();
            if (propType.isEnum()) {
                return propType;
            }
            if (primitives.containsKey(propType)) {
                return (Class)primitives.get(propType);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean hasEmbeddedProperty(String entityType, String[] propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(entity, propertyPath).getPropertyType();
            return propType != null && !propType.isEnum() && !primitives.containsKey(propType);
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    @Override
    public boolean isRepeatedProperty(String entityType, String[] propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        try {
            ReflectionHelper.PropertyAccessor a = ReflectionHelper.getAccessor(entity, propertyPath[0]);
            if (a.isMultiple()) {
                return true;
            }
            for (int i = 1; i < propertyPath.length; ++i) {
                if (!(a = a.getAccessor(propertyPath[i])).isMultiple()) continue;
                return true;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean hasProperty(String entityType, String[] propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(entity, propertyPath).getPropertyType();
            return propType != null;
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    private ReflectionHelper.PropertyAccessor getPropertyAccessor(Class<?> entityClass, String[] propertyPath) throws IntrospectionException {
        ReflectionHelper.PropertyAccessor accessor = ReflectionHelper.getAccessor(entityClass, propertyPath[0]);
        for (int i = 1; i < propertyPath.length; ++i) {
            accessor = accessor.getAccessor(propertyPath[i]);
        }
        return accessor;
    }
}

