/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.Date;
import java.util.Map;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.util.DateHelper;

public final class ConstantValueExpr
implements ValueExpr {
    private final Comparable constantValue;

    public ConstantValueExpr(Comparable constantValue) {
        if (constantValue == null) {
            throw new IllegalArgumentException("constantValue cannot be null");
        }
        this.constantValue = constantValue;
    }

    public Comparable getConstantValue() {
        if (this.isParameter()) {
            throw new IllegalStateException("The value is a parameter " + this.constantValue);
        }
        return this.constantValue;
    }

    public boolean isParameter() {
        return this.constantValue instanceof ParamPlaceholder;
    }

    public Comparable getConstantValueAs(Class<?> targetType, Map<String, Object> namedParameters) {
        Class<?> type;
        Comparable value;
        if (this.constantValue instanceof ParamPlaceholder) {
            String paramName = ((ParamPlaceholder)this.constantValue).getName();
            value = (Comparable)namedParameters.get(paramName);
            if (value == null) {
                throw new IllegalStateException("Missing value for parameter " + paramName);
            }
        } else {
            value = this.constantValue;
        }
        if ((type = value.getClass()) != targetType) {
            if (targetType == String.class) {
                return value.toString();
            }
            if (targetType == Boolean.class) {
                if (type == String.class) {
                    return Boolean.valueOf((String)((Object)value));
                }
            } else if (targetType == Double.class) {
                if (type == String.class) {
                    return Double.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Double.valueOf(((Number)((Object)value)).doubleValue());
                }
            } else if (targetType == Float.class) {
                if (type == String.class) {
                    return Float.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Float.valueOf(((Number)((Object)value)).floatValue());
                }
            } else if (targetType == Long.class) {
                if (type == String.class) {
                    return Long.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Long.valueOf(((Number)((Object)value)).longValue());
                }
            } else if (targetType == Integer.class) {
                if (type == String.class) {
                    return Integer.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Integer.valueOf(((Number)((Object)value)).intValue());
                }
            } else if (targetType == Short.class) {
                if (type == String.class) {
                    return Short.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Short.valueOf(((Number)((Object)value)).shortValue());
                }
            } else if (targetType == Byte.class) {
                if (type == String.class) {
                    return Byte.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Byte.valueOf(((Number)((Object)value)).byteValue());
                }
            }
        }
        return value;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantValueExpr other = (ConstantValueExpr)o;
        return this.constantValue.equals(other.constantValue);
    }

    public int hashCode() {
        return this.constantValue.hashCode();
    }

    public String toString() {
        return "CONST(" + this.constantValue + ')';
    }

    @Override
    public String toJpaString() {
        if (this.constantValue instanceof ParamPlaceholder) {
            return this.constantValue.toString();
        }
        if (this.constantValue instanceof String) {
            return "\"" + this.constantValue + "\"";
        }
        if (this.constantValue instanceof Character) {
            return "'" + this.constantValue + "'";
        }
        if (this.constantValue instanceof Date) {
            return "'" + DateHelper.getJpaDateFormat().format((Date)this.constantValue) + "'";
        }
        return "" + this.constantValue;
    }

    public static final class ParamPlaceholder
    implements Comparable {
        private final String name;

        public ParamPlaceholder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return ":" + this.getName();
        }

        public int compareTo(Object o) {
            return 0;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == ParamPlaceholder.class && this.name.equals(((ParamPlaceholder)obj).getName());
        }
    }
}

