/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.util.Util;

public final class Attribute<T>
implements Cloneable {
    private final AttributeDefinition<T> definition;
    protected T value;
    private boolean protect;
    private boolean modified;
    private List<AttributeListener<T>> listeners;

    Attribute(AttributeDefinition<T> definition) {
        this.definition = definition;
        this.value = definition.getDefaultValue();
    }

    public String name() {
        return this.definition.name();
    }

    public T get() {
        return this.value;
    }

    public T getInitialValue() {
        return this.definition.getDefaultValue();
    }

    public void validate() {
        this.definition.validate(this.value);
    }

    public Attribute<T> protect() {
        if (!this.protect && this.definition.isImmutable()) {
            this.protect = true;
        }
        return this;
    }

    public void set(T value) {
        if (this.protect) {
            throw new IllegalStateException();
        }
        T oldValue = this.value;
        this.value = value;
        this.modified = true;
        this.fireValueChanged(oldValue);
    }

    public boolean isImmutable() {
        return this.definition.isImmutable();
    }

    public boolean isPersistent() {
        return this.definition.isAutoPersist();
    }

    public boolean isModified() {
        return this.modified;
    }

    public <K> K asObject() {
        return (K)this.value;
    }

    public void addListener(AttributeListener<T> listener) {
        if (this.isImmutable()) {
            throw new UnsupportedOperationException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<AttributeListener<T>>();
        }
        this.listeners.add(listener);
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value) {
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    boolean isProtect() {
        return this.protect;
    }

    void setProtect(boolean protect) {
        this.protect = protect;
    }

    public AttributeDefinition<T> getAttributeDefinition() {
        return this.definition;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    private void fireValueChanged(T oldValue) {
        if (this.listeners != null) {
            for (AttributeListener<T> listener : this.listeners) {
                listener.attributeChanged(this, oldValue);
            }
        }
    }

    protected Attribute<T> clone() {
        try {
            Attribute clone = (Attribute)super.clone();
            clone.modified = this.modified;
            clone.listeners = null;
            clone.protect = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    public void read(Attribute<T> other) {
        AttributeCopier copier = this.definition.copier();
        if (copier == null) {
            Object clone = other.clone();
            this.value = ((Attribute)clone).value;
        } else {
            this.value = copier.copyAttribute(other.value);
        }
        this.modified = other.modified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.modified ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.definition.name() + "=" + this.value;
    }

    public void reset() {
        if (this.protect) {
            throw new IllegalStateException("Cannot reset a protected Attribute");
        }
        this.value = this.definition.getDefaultValue();
        this.modified = false;
    }

    void write(XMLStreamWriter writer, String name) throws XMLStreamException {
        if (this.modified && this.value != null) {
            Class<?> klass = this.value.getClass();
            if (klass == Class.class) {
                writer.writeAttribute(name, ((Class)this.value).getName());
            } else if (klass.isEnum()) {
                writer.writeAttribute(name, ((Enum)this.value).name());
            } else if (Util.isBasicType(klass)) {
                writer.writeAttribute(name, this.value.toString());
            } else {
                writer.writeAttribute(name, klass.getName());
            }
        }
    }
}

