/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.FieldCustomization;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.FieldBridgeCustomization;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryParsingResult;
import org.infinispan.query.logging.Log;
import org.jboss.logging.Logger;

public final class LuceneQueryMaker
implements Visitor<Query, Query> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)LuceneQueryMaker.class.getName());
    private static final char LUCENE_SINGLE_CHARACTER_WILDCARD = '?';
    private static final char LUCENE_MULTIPLE_CHARACTERS_WILDCARD = '*';
    private final QueryContextBuilder queryContextBuilder;
    private final HibernateSearchPropertyHelper propertyHelper;
    private final FieldBridgeProvider fieldBridgeProvider;
    private Map<String, Object> namedParameters;
    private QueryBuilder queryBuilder;
    private String entityTypeName;

    public LuceneQueryMaker(SearchIntegrator searchFactory, HibernateSearchPropertyHelper propertyHelper, FieldBridgeProvider fieldBridgeProvider) {
        if (searchFactory == null) {
            throw new IllegalArgumentException("searchFactory argument cannot be null");
        }
        if (propertyHelper == null && fieldBridgeProvider == null) {
            throw new IllegalArgumentException("propertyHelper and fieldBridgeProvider argument cannot be both null");
        }
        this.propertyHelper = propertyHelper;
        this.fieldBridgeProvider = fieldBridgeProvider != null ? fieldBridgeProvider : propertyHelper::getDefaultFieldBridge;
        this.queryContextBuilder = searchFactory.buildQueryBuilder();
    }

    public <TypeMetadata> LuceneQueryParsingResult<TypeMetadata> transform(FilterParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, Class<?> targetedType) {
        this.namedParameters = namedParameters;
        this.queryBuilder = this.queryContextBuilder.forEntity(targetedType).get();
        this.entityTypeName = parsingResult.getTargetEntityName();
        Query query = this.makeQuery(parsingResult.getWhereClause());
        Sort sort = this.makeSort(parsingResult.getSortFields());
        return new LuceneQueryParsingResult<Object>(query, parsingResult.getTargetEntityName(), parsingResult.getTargetEntityMetadata(), parsingResult.getProjections(), sort);
    }

    private Query makeQuery(BooleanExpr expr) {
        return expr == null ? this.queryBuilder.all().createQuery() : (Query)expr.acceptVisitor((Visitor)this);
    }

    private Sort makeSort(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return null;
        }
        org.apache.lucene.search.SortField[] fields = new org.apache.lucene.search.SortField[sortFields.length];
        for (int i = 0; i < fields.length; ++i) {
            SortField sf = sortFields[i];
            SortField.Type sortType = SortField.Type.STRING;
            String[] propertyPath = sf.getPath().getPath();
            this.ensureNotAnalyzed(propertyPath);
            FieldBridge fieldBridge = this.fieldBridgeProvider.getFieldBridge(this.entityTypeName, propertyPath);
            if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
                fieldBridge = ((NullEncodingTwoWayFieldBridge)fieldBridge).unwrap();
            }
            if (fieldBridge instanceof NumericFieldBridge) {
                switch ((NumericFieldBridge)fieldBridge) {
                    case INT_FIELD_BRIDGE: {
                        sortType = SortField.Type.INT;
                        break;
                    }
                    case LONG_FIELD_BRIDGE: {
                        sortType = SortField.Type.LONG;
                        break;
                    }
                    case FLOAT_FIELD_BRIDGE: {
                        sortType = SortField.Type.FLOAT;
                        break;
                    }
                    case DOUBLE_FIELD_BRIDGE: {
                        sortType = SortField.Type.DOUBLE;
                    }
                }
            }
            fields[i] = new org.apache.lucene.search.SortField(sf.getPath().asStringPath(), sortType, !sf.isAscending());
        }
        return new Sort(fields);
    }

    private void ensureNotAnalyzed(String[] path) {
        if (this.propertyHelper != null && this.propertyHelper.hasAnalyzedProperty(this.entityTypeName, path)) {
            throw log.getQueryOnAnalyzedPropertyNotSupportedException(this.entityTypeName, StringHelper.join((String[])path));
        }
    }

    public Query visit(NotExpr notExpr) {
        Query transformedChild = (Query)notExpr.getChild().acceptVisitor((Visitor)this);
        return this.queryBuilder.bool().must(transformedChild).not().createQuery();
    }

    public Query visit(OrExpr orExpr) {
        BooleanJunction booleanJunction = this.queryBuilder.bool();
        for (BooleanExpr c : orExpr.getChildren()) {
            Query transformedChild = (Query)c.acceptVisitor((Visitor)this);
            booleanJunction.should(transformedChild);
        }
        return booleanJunction.createQuery();
    }

    public Query visit(AndExpr andExpr) {
        BooleanJunction booleanJunction = this.queryBuilder.bool();
        for (BooleanExpr c : andExpr.getChildren()) {
            Query transformedChild;
            if (c instanceof NotExpr) {
                c = ((NotExpr)c).getChild();
                transformedChild = (Query)c.acceptVisitor((Visitor)this);
                booleanJunction.must(transformedChild).not();
                continue;
            }
            transformedChild = (Query)c.acceptVisitor((Visitor)this);
            booleanJunction.must(transformedChild);
        }
        return booleanJunction.createQuery();
    }

    public Query visit(IsNullExpr isNullExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)isNullExpr.getChild();
        String[] propertyPath = propertyValueExpr.getPropertyPath();
        this.ensureNotAnalyzed(propertyPath);
        return this.applyFieldBridge(propertyPath, this.queryBuilder.keyword().onField(StringHelper.join((String[])propertyPath))).matching(null).createQuery();
    }

    public Query visit(ComparisonExpr comparisonExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)comparisonExpr.getLeftChild();
        ConstantValueExpr constantValueExpr = (ConstantValueExpr)comparisonExpr.getRightChild();
        Comparable value = constantValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        String[] propertyPath = propertyValueExpr.getPropertyPath();
        this.ensureNotAnalyzed(propertyPath);
        String path = StringHelper.join((String[])propertyPath);
        switch (comparisonExpr.getComparisonType()) {
            case NOT_EQUAL: {
                Query q = this.applyFieldBridge(propertyPath, this.queryBuilder.keyword().onField(path)).matching((Object)value).createQuery();
                return this.queryBuilder.bool().must(q).not().createQuery();
            }
            case EQUAL: {
                return this.applyFieldBridge(propertyPath, this.queryBuilder.keyword().onField(path)).matching((Object)value).createQuery();
            }
            case LESS: {
                return this.applyFieldBridge(propertyPath, this.queryBuilder.range().onField(path)).below((Object)value).excludeLimit().createQuery();
            }
            case LESS_OR_EQUAL: {
                return this.applyFieldBridge(propertyPath, this.queryBuilder.range().onField(path)).below((Object)value).createQuery();
            }
            case GREATER: {
                return this.applyFieldBridge(propertyPath, this.queryBuilder.range().onField(path)).above((Object)value).excludeLimit().createQuery();
            }
            case GREATER_OR_EQUAL: {
                return this.applyFieldBridge(propertyPath, this.queryBuilder.range().onField(path)).above((Object)value).createQuery();
            }
        }
        throw new IllegalStateException("Unexpected comparison type: " + comparisonExpr.getComparisonType());
    }

    public Query visit(LikeExpr likeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)likeExpr.getChild();
        String[] propertyPath = propertyValueExpr.getPropertyPath();
        this.ensureNotAnalyzed(propertyPath);
        StringBuilder lucenePattern = new StringBuilder(likeExpr.getPattern());
        block5: for (int i = 0; i < lucenePattern.length(); ++i) {
            switch (lucenePattern.charAt(i)) {
                case '*': 
                case '?': {
                    lucenePattern.insert(i, '\\');
                    ++i;
                    continue block5;
                }
                case '%': {
                    lucenePattern.setCharAt(i, '*');
                    continue block5;
                }
                case '_': {
                    lucenePattern.setCharAt(i, '?');
                }
            }
        }
        return this.applyFieldBridge(propertyPath, this.queryBuilder.keyword().wildcard().onField(StringHelper.join((String[])propertyPath))).matching((Object)lucenePattern.toString()).createQuery();
    }

    public Query visit(ConstantBooleanExpr constantBooleanExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public Query visit(ConstantValueExpr constantValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public Query visit(PropertyValueExpr propertyValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public Query visit(AggregationExpr aggregationExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    private <F extends FieldCustomization> F applyFieldBridge(String[] propertyPath, F f) {
        FieldBridge fieldBridge = this.fieldBridgeProvider.getFieldBridge(this.entityTypeName, propertyPath);
        if (fieldBridge != null) {
            ((FieldBridgeCustomization)f).withFieldBridge(fieldBridge);
            f.ignoreAnalyzer();
        }
        return f;
    }

    @FunctionalInterface
    public static interface FieldBridgeProvider {
        public FieldBridge getFieldBridge(String var1, String[] var2);
    }
}

