/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;
import org.infinispan.util.ByteString;

public class IndexUpdateStreamCommand
extends AbstractUpdateCommand {
    public static final byte COMMAND_ID = 103;

    public IndexUpdateStreamCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.queryInterceptor.isStopping()) {
            throw log.cacheIsStoppingNoCommandAllowed(this.cacheName.toString());
        }
        IndexManager indexManager = this.searchFactory.getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced : " + this.indexName);
        }
        List luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        LuceneWork workToApply = this.transformKeyToStrings((LuceneWork)luceneWorks.iterator().next());
        indexManager.performStreamOperation(workToApply, null, true);
        return Boolean.TRUE;
    }

    @Override
    public byte getCommandId() {
        return 103;
    }
}

