/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.beans.IntrospectionException;
import java.util.Arrays;
import java.util.List;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;
import org.jboss.logging.Logger;

public class ReflectionPropertyHelper
extends ObjectPropertyHelper<Class<?>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ReflectionPropertyHelper.class.getName());

    public ReflectionPropertyHelper(EntityNamesResolver entityNamesResolver) {
        super(entityNamesResolver);
    }

    @Override
    public Class<?> getEntityMetadata(String targetTypeName) {
        return this.entityNamesResolver.getClassFromName(targetTypeName);
    }

    @Override
    public List<?> mapPropertyNamePathToFieldIdPath(Class<?> type, String[] propertyPath) {
        return Arrays.asList(propertyPath);
    }

    @Override
    public Class<?> getPrimitivePropertyType(String entityType, String[] propertyPath) {
        Class<?> entityClass = this.getEntityClass(entityType);
        try {
            Class<?> propType = this.getPropertyAccessor(entityClass, propertyPath).getPropertyType();
            if (propType.isEnum()) {
                return propType;
            }
            return (Class)primitives.get(propType);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public boolean hasEmbeddedProperty(String entityType, String[] propertyPath) {
        Class<?> entityClass = this.getEntityClass(entityType);
        try {
            Class<?> propType = this.getPropertyAccessor(entityClass, propertyPath).getPropertyType();
            return propType != null && !propType.isEnum() && !primitives.containsKey(propType);
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    @Override
    public boolean isRepeatedProperty(String entityType, String[] propertyPath) {
        Class<?> entityClass = this.getEntityClass(entityType);
        try {
            ReflectionHelper.PropertyAccessor a = ReflectionHelper.getAccessor(entityClass, propertyPath[0]);
            if (a.isMultiple()) {
                return true;
            }
            for (int i = 1; i < propertyPath.length; ++i) {
                if (!(a = a.getAccessor(propertyPath[i])).isMultiple()) continue;
                return true;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean hasProperty(String entityType, String[] propertyPath) {
        Class<?> entityClass = this.getEntityClass(entityType);
        try {
            Class<?> propType = this.getPropertyAccessor(entityClass, propertyPath).getPropertyType();
            return propType != null;
        }
        catch (IntrospectionException e) {
            return false;
        }
    }

    private Class<?> getEntityClass(String entityType) {
        Object entityClass = this.getEntityMetadata(entityType);
        if (entityClass == null) {
            throw log.getUnknownEntity(entityType);
        }
        return entityClass;
    }

    private ReflectionHelper.PropertyAccessor getPropertyAccessor(Class<?> entityClass, String[] propertyPath) throws IntrospectionException {
        ReflectionHelper.PropertyAccessor accessor = ReflectionHelper.getAccessor(entityClass, propertyPath[0]);
        for (int i = 1; i < propertyPath.length; ++i) {
            accessor = accessor.getAccessor(propertyPath[i]);
        }
        return accessor;
    }
}

