/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cdi.common.util.Reflections;
import org.infinispan.cdi.embedded.InfinispanExtensionEmbedded;
import org.infinispan.cdi.embedded.event.cache.CacheEventBridge;
import org.infinispan.cdi.embedded.event.cachemanager.CacheManagerEventBridge;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;

public class AdvancedCacheProducer {
    @Inject
    private CacheContainer defaultCacheContainer;
    @Inject
    private CacheEventBridge cacheEventBridge;
    @Inject
    private InfinispanExtensionEmbedded infinispanExtension;
    @Inject
    @Any
    private Instance<EmbeddedCacheManager> cacheManagers;
    @Inject
    private BeanManager beanManager;
    @Inject
    private CacheManagerEventBridge eventBridge;

    private CacheContainer getCacheContainer(Set<Annotation> qualifiers) {
        Instance cacheContainer = this.cacheManagers.select(qualifiers.toArray(Reflections.EMPTY_ANNOTATION_ARRAY));
        if (cacheContainer.isUnsatisfied()) {
            return this.defaultCacheContainer;
        }
        return (CacheContainer)cacheContainer.get();
    }

    public <K, V> AdvancedCache<K, V> getAdvancedCache(String name, Set<Annotation> qualifiers) {
        this.infinispanExtension.registerCacheConfigurations(this.eventBridge, this.cacheManagers, this.beanManager);
        CacheContainer container = this.getCacheContainer(qualifiers);
        Cache cache = name.isEmpty() ? container.getCache() : container.getCache(name);
        this.cacheEventBridge.registerObservers(qualifiers, (Listenable)cache);
        return cache.getAdvancedCache();
    }

    @Produces
    <K, V> AdvancedCache<K, V> getDefaultAdvancedCache() {
        this.infinispanExtension.registerCacheConfigurations(this.eventBridge, this.cacheManagers, this.beanManager);
        return this.defaultCacheContainer.getCache().getAdvancedCache();
    }
}

